/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.Msg;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class SimpleTimeZone
extends TimeZone {
    private String ID;
    private int rawOffset;
    private int startYear;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startMode;
    private int endMode;
    private int startTimeMode;
    private int endTimeMode;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    static final int UTC_TIME = 2;
    static final int STANDARD_TIME = 1;
    static final int WALL_TIME = 0;
    private boolean useDaylight;
    private GregorianCalendar daylightSavings;
    private int dstSavings = 3600000;

    public SimpleTimeZone(int offset, String name) {
        this.ID = name;
        this.rawOffset = offset;
    }

    public SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime) {
        this(offset, name, startMonth, startDay, startDayOfWeek, startTime, endMonth, endDay, endDayOfWeek, endTime, 3600000);
    }

    public SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int daylightSavings) {
        this(offset, name);
        if (daylightSavings <= 0) {
            throw new IllegalArgumentException(Msg.getString("K00e9", daylightSavings));
        }
        this.dstSavings = daylightSavings;
        this.setStartRule(startMonth, startDay, startDayOfWeek, startTime);
        this.setEndRule(endMonth, endDay, endDayOfWeek, endTime);
    }

    SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int startTimeMode, int endMonth, int endDay, int endDayOfWeek, int endTime, int endTimeMode, int daylightSavings) {
        this(offset, name);
        if (daylightSavings <= 0) {
            throw new IllegalArgumentException(Msg.getString("K00e9", daylightSavings));
        }
        this.dstSavings = daylightSavings;
        this.setStartRule(startMonth, startDay, startDayOfWeek, startTime);
        this.setEndRule(endMonth, endDay, endDayOfWeek, endTime);
        if (startTimeMode > 2 || startTimeMode < 0) {
            throw new IllegalArgumentException(Msg.getString("K03c5", startTimeMode));
        }
        this.startTimeMode = startTimeMode;
        if (endTimeMode > 2 || endTimeMode < 0) {
            throw new IllegalArgumentException(Msg.getString("K03c5", endTimeMode));
        }
        this.endTimeMode = endTimeMode;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int time) {
        int previousMonth;
        if (era != 0 && era != 1) {
            throw new IllegalArgumentException(Msg.getString("K00ea", era));
        }
        this.checkRange(month, dayOfWeek, time);
        if (month != 1 || day != 29 || !this.isLeapYear(year)) {
            this.checkDay(month, day);
        }
        if ((previousMonth = month - 1) < 0) {
            previousMonth = 11;
        }
        if (!this.useDaylightTime() || era != 1 || year < this.startYear) {
            return this.rawOffset;
        }
        boolean afterStart = false;
        boolean beforeEnd = false;
        int ruleDay = 0;
        int ruleTime = this.startTime;
        if (this.startTimeMode == 2) {
            ruleTime += this.rawOffset;
        }
        int startRuleMonth = this.startMonth;
        int prevStartMonth = this.startMonth - 1;
        if (prevStartMonth < 0) {
            prevStartMonth = 11;
        }
        if (month == this.startMonth || month == prevStartMonth || previousMonth == this.startMonth) {
            int daysInPrevStartMonth = GregorianCalendar.DaysInMonth[prevStartMonth];
            if (prevStartMonth == 1 && this.isLeapYear(year)) {
                ++daysInPrevStartMonth;
            }
            int daysInStartMonth = GregorianCalendar.DaysInMonth[this.startMonth];
            if (this.startMonth == 1 && this.isLeapYear(year)) {
                ++daysInStartMonth;
            }
            int firstDayOfMonth = this.mod7(dayOfWeek - day);
            if (month != this.startMonth) {
                firstDayOfMonth = month == prevStartMonth ? this.mod7(firstDayOfMonth + daysInPrevStartMonth) : this.mod7(firstDayOfMonth - daysInStartMonth);
            }
            switch (this.startMode) {
                case 1: {
                    ruleDay = this.startDay;
                    break;
                }
                case 2: {
                    if (this.startDay >= 0) {
                        ruleDay = this.mod7(this.startDayOfWeek - firstDayOfMonth) + 1 + (this.startDay - 1) * 7;
                        break;
                    }
                    ruleDay = daysInStartMonth + 1 + this.mod7(this.startDayOfWeek - (firstDayOfMonth + daysInStartMonth)) + this.startDay * 7;
                    break;
                }
                case 3: {
                    ruleDay = this.startDay + this.mod7(this.startDayOfWeek - (firstDayOfMonth + this.startDay - 1));
                    break;
                }
                case 4: {
                    ruleDay = this.startDay + this.mod7(this.startDayOfWeek - (firstDayOfMonth + this.startDay - 1));
                    if (ruleDay == this.startDay) break;
                    ruleDay -= 7;
                }
            }
            if (ruleTime < 0) {
                --ruleDay;
                ruleTime += 86400000;
            }
            if (ruleTime >= 86400000) {
                ++ruleDay;
                ruleTime -= 86400000;
            }
            if (ruleDay > daysInStartMonth) {
                if (++startRuleMonth > 11) {
                    startRuleMonth = 0;
                }
                ruleDay -= daysInStartMonth;
            }
            if (ruleDay < 1) {
                if (--startRuleMonth < 0) {
                    startRuleMonth = 11;
                }
                ruleDay += daysInPrevStartMonth;
            }
            if (month == startRuleMonth && (day > ruleDay || day == ruleDay && time >= ruleTime)) {
                afterStart = true;
            }
        }
        ruleTime = this.endTime;
        if (this.endTimeMode == 0) {
            ruleTime -= this.dstSavings;
        } else if (this.endTimeMode == 2) {
            ruleTime += this.rawOffset;
        }
        int endRuleMonth = this.endMonth;
        int prevEndMonth = this.endMonth - 1;
        if (prevEndMonth < 0) {
            prevEndMonth = 11;
        }
        if (month == this.endMonth || month == prevEndMonth || previousMonth == this.endMonth) {
            int daysInPrevEndMonth = GregorianCalendar.DaysInMonth[prevEndMonth];
            if (prevEndMonth == 1 && this.isLeapYear(year)) {
                ++daysInPrevEndMonth;
            }
            int daysInEndMonth = GregorianCalendar.DaysInMonth[this.endMonth];
            if (this.endMonth == 1 && this.isLeapYear(year)) {
                ++daysInEndMonth;
            }
            int firstDayOfMonth = this.mod7(dayOfWeek - day);
            if (month != this.endMonth) {
                firstDayOfMonth = month == prevEndMonth ? this.mod7(firstDayOfMonth + daysInPrevEndMonth) : this.mod7(firstDayOfMonth - daysInEndMonth);
            }
            switch (this.endMode) {
                case 1: {
                    ruleDay = this.endDay;
                    break;
                }
                case 2: {
                    if (this.endDay >= 0) {
                        ruleDay = this.mod7(this.endDayOfWeek - firstDayOfMonth) + 1 + (this.endDay - 1) * 7;
                        break;
                    }
                    ruleDay = daysInEndMonth + 1 + this.mod7(this.endDayOfWeek - (firstDayOfMonth + daysInEndMonth)) + this.endDay * 7;
                    break;
                }
                case 3: {
                    ruleDay = this.endDay + this.mod7(this.endDayOfWeek - (firstDayOfMonth + this.endDay - 1));
                    break;
                }
                case 4: {
                    ruleDay = this.endDay + this.mod7(this.endDayOfWeek - (firstDayOfMonth + this.endDay - 1));
                    if (ruleDay == this.endDay) break;
                    ruleDay -= 7;
                }
            }
            if (ruleTime < 0) {
                --ruleDay;
                ruleTime += 86400000;
            }
            if (ruleTime >= 86400000) {
                ++ruleDay;
                ruleTime -= 86400000;
            }
            if (ruleDay > daysInEndMonth) {
                if (++endRuleMonth > 11) {
                    endRuleMonth = 0;
                }
                ruleDay -= daysInEndMonth;
            }
            if (ruleDay < 1) {
                if (--endRuleMonth < 0) {
                    endRuleMonth = 11;
                }
                ruleDay += daysInPrevEndMonth;
            }
            if (month == endRuleMonth && (day < ruleDay || day == ruleDay && time < ruleTime)) {
                beforeEnd = true;
            }
        }
        if (endRuleMonth >= startRuleMonth ? !(!afterStart && month <= startRuleMonth || !beforeEnd && month >= endRuleMonth) : !(!afterStart && month <= startRuleMonth && month > endRuleMonth || !beforeEnd && month >= endRuleMonth && month < startRuleMonth)) {
            return this.rawOffset + this.dstSavings;
        }
        return this.rawOffset;
    }

    int getOffset(long time) {
        if (!this.useDaylightTime()) {
            return this.rawOffset;
        }
        if (this.daylightSavings == null) {
            GregorianCalendar cal = new GregorianCalendar(false);
            cal.setTimeZone(this);
            this.daylightSavings = cal;
        }
        return this.daylightSavings.getOffset(time + (long)this.rawOffset);
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    boolean inDaylightTime(Date time) {
        long millis = time.getTime();
        if (!this.useDaylightTime()) {
            return false;
        }
        if (this.daylightSavings == null) {
            GregorianCalendar cal = new GregorianCalendar(false);
            cal.setTimeZone(this);
            this.daylightSavings = cal;
        }
        return this.daylightSavings.getOffset(millis + (long)this.rawOffset) != this.rawOffset;
    }

    private boolean isLeapYear(int year) {
        if (year > 1582) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    private int mod7(int num1) {
        int rem = num1 % 7;
        return num1 < 0 && rem < 0 ? 7 + rem : rem;
    }

    private void checkRange(int month, int dayOfWeek, int time) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException(Msg.getString("K00e5", month));
        }
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException(Msg.getString("K00e7", dayOfWeek));
        }
        if (time < 0 || time >= 86400000) {
            throw new IllegalArgumentException(Msg.getString("K00e8", time));
        }
    }

    private void checkDay(int month, int day) {
        if (day <= 0 || day > GregorianCalendar.DaysInMonth[month]) {
            throw new IllegalArgumentException(Msg.getString("K00e6", day));
        }
    }

    private void setEndMode() {
        if (this.endDayOfWeek == 0) {
            this.endMode = 1;
        } else if (this.endDayOfWeek < 0) {
            this.endDayOfWeek = -this.endDayOfWeek;
            if (this.endDay < 0) {
                this.endDay = -this.endDay;
                this.endMode = 4;
            } else {
                this.endMode = 3;
            }
        } else {
            this.endMode = 2;
        }
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            this.checkRange(this.endMonth, this.endMode == 1 ? 1 : this.endDayOfWeek, this.endTime);
            if (this.endMode != 2) {
                this.checkDay(this.endMonth, this.endDay);
            } else if (this.endDay < -5 || this.endDay > 5) {
                throw new IllegalArgumentException(Msg.getString("K00f8", this.endDay));
            }
        }
        if (this.endMode != 1) {
            --this.endDayOfWeek;
        }
    }

    public void setEndRule(int month, int dayOfMonth, int time) {
        this.endMonth = month;
        this.endDay = dayOfMonth;
        this.endDayOfWeek = 0;
        this.endTime = time;
        this.endTimeMode = 0;
        this.setEndMode();
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time) {
        this.endMonth = month;
        this.endDay = day;
        this.endDayOfWeek = dayOfWeek;
        this.endTime = time;
        this.endTimeMode = 0;
        this.setEndMode();
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time, boolean after) {
        this.endMonth = month;
        this.endDay = after ? day : -day;
        this.endDayOfWeek = -dayOfWeek;
        this.endTime = time;
        this.endTimeMode = 0;
        this.setEndMode();
    }

    private void setStartMode() {
        if (this.startDayOfWeek == 0) {
            this.startMode = 1;
        } else if (this.startDayOfWeek < 0) {
            this.startDayOfWeek = -this.startDayOfWeek;
            if (this.startDay < 0) {
                this.startDay = -this.startDay;
                this.startMode = 4;
            } else {
                this.startMode = 3;
            }
        } else {
            this.startMode = 2;
        }
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            this.checkRange(this.startMonth, this.startMode == 1 ? 1 : this.startDayOfWeek, this.startTime);
            if (this.startMode != 2) {
                this.checkDay(this.startMonth, this.startDay);
            } else if (this.startDay < -5 || this.startDay > 5) {
                throw new IllegalArgumentException(Msg.getString("K00f8", this.startDay));
            }
        }
        if (this.startMode != 1) {
            --this.startDayOfWeek;
        }
    }

    public void setStartRule(int month, int dayOfMonth, int time) {
        this.startMonth = month;
        this.startDay = dayOfMonth;
        this.startDayOfWeek = 0;
        this.startTime = time;
        this.startTimeMode = 0;
        this.setStartMode();
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time) {
        this.startMonth = month;
        this.startDay = day;
        this.startDayOfWeek = dayOfWeek;
        this.startTime = time;
        this.startTimeMode = 0;
        this.setStartMode();
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time, boolean after) {
        this.startMonth = month;
        this.startDay = after ? day : -day;
        this.startDayOfWeek = -dayOfWeek;
        this.startTime = time;
        this.startTimeMode = 0;
        this.setStartMode();
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public String getID() {
        return this.ID;
    }
}

