/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.midlet;

import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.ui.ConfirmData;
import com.nokia.mj.impl.rt.ui.RuntimeUi;
import com.nokia.mj.impl.rt.ui.RuntimeUiFactory;
import com.nokia.mj.impl.security.midp.authorization.AccessControllerFactoryImpl;
import com.nokia.mj.impl.security.midp.authorization.AccessControllerImpl;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import com.nokia.mj.impl.utils.Logger;
import java.util.Hashtable;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.midlet.MidletApplication;

public abstract class MIDlet {
    private MidletApplication mMidletApplication;
    private static Hashtable mNetworkPromptSchemes = null;
    private static Hashtable mNoPromptSchemes = null;
    private static boolean mConstructionAllowed = true;

    public final int checkPermission(String permission) {
        try {
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            AccessControllerImpl accessControllerImpl = AccessControllerFactoryImpl.getAccessController(appInfo.getSuiteUid(), appInfo.getName());
            return accessControllerImpl.checkPermission(permission);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public final void notifyDestroyed() {
        this.mMidletApplication.notifyDestroyed();
    }

    public final void notifyPaused() {
        this.mMidletApplication.notifyPaused();
    }

    public final void resumeRequest() {
        this.mMidletApplication.resumeRequest();
    }

    public final String getAppProperty(String key) {
        if (key == null) {
            throw new NullPointerException("MIDlet.getAppProperty() called with null key");
        }
        return this.mMidletApplication.getAppProperty(key);
    }

    public final boolean platformRequest(String url) throws ConnectionNotFoundException {
        Logger.LOG(2, 4, "MIDlet.platformRequest(): " + url);
        if (null == url) {
            throw new NullPointerException("URL is null");
        }
        if ((url = url.trim()).equals("")) {
            return false;
        }
        Logger.LOG(2, 4, "Before handleConfirmationNote()");
        boolean acceptByUser = this.handleConfirmationNote(url);
        Logger.LOG(2, 4, "After handleConfirmationNote(): " + acceptByUser);
        if (!acceptByUser) {
            throw new ConnectionNotFoundException("Request was cancelled by user");
        }
        this._managePlatformRequest(url);
        return false;
    }

    protected MIDlet() {
        if (!mConstructionAllowed) {
            throw new SecurityException("Only application management software is allowed to construct MIDlet");
        }
        mConstructionAllowed = false;
        this.mMidletApplication = new MidletApplication(this);
        Logger.LOG(2, 4, "MIDlet created: " + this);
    }

    protected abstract void destroyApp(boolean var1) throws MIDletStateChangeException;

    protected abstract void startApp() throws MIDletStateChangeException;

    protected abstract void pauseApp();

    private boolean handleConfirmationNote(String url) throws ConnectionNotFoundException {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        String domain = appInfo.getProtectionDomain();
        if ("MFD".equals(domain) || "OPD".equals(domain)) {
            return true;
        }
        if (mNetworkPromptSchemes == null || mNoPromptSchemes == null) {
            this.fillSchemes();
        }
        String scheme = this.getScheme(url);
        String appName = appInfo.getName();
        if (mNetworkPromptSchemes.containsKey(scheme)) {
            return this.showNote(appName, "network_usage_via_plat_req");
        }
        if (mNoPromptSchemes.containsKey(scheme)) {
            return true;
        }
        return this.showNote(appName, "app_launch_via_plat_req");
    }

    private boolean showNote(String aAppName, String aConfirmationQueryId) {
        SecurityPromptMessage msg = SecurityPromptMessage.getInstance();
        String queryTxt = msg.getText(aConfirmationQueryId, null);
        String[] buttons = new String[]{msg.getText("prompt_allow", null), msg.getText("prompt_deny", null)};
        ConfirmData dataObj = new ConfirmData(queryTxt, buttons, 0);
        RuntimeUi uiObj = RuntimeUiFactory.getRuntimeUi();
        boolean isUserAnswered = uiObj.confirm(aAppName, dataObj);
        if (!isUserAnswered) {
            return false;
        }
        int indexToChosenButton = dataObj.getAnswer();
        return indexToChosenButton == 0;
    }

    private void fillSchemes() {
        if (mNetworkPromptSchemes == null) {
            mNetworkPromptSchemes = new Hashtable();
            mNetworkPromptSchemes.put("http:", "");
            mNetworkPromptSchemes.put("https:", "");
            mNetworkPromptSchemes.put("rtsp:", "");
        }
        if (mNoPromptSchemes == null) {
            mNoPromptSchemes = new Hashtable();
            mNoPromptSchemes.put("tel:", "");
        }
    }

    private String getScheme(String uri) throws ConnectionNotFoundException {
        int index = uri.indexOf(58);
        if (index == -1) {
            throw new ConnectionNotFoundException("Incorrect URI: " + uri);
        }
        if (uri.length() <= ++index) {
            throw new ConnectionNotFoundException("Incorrect URI: " + uri);
        }
        return uri.substring(0, index);
    }

    private native void _managePlatformRequest(String var1);
}

