/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.pim;

import com.nokia.mj.impl.pim.GenericException;
import com.nokia.mj.impl.pim.PIMManager;
import com.nokia.mj.impl.pim.PIMTools;
import com.nokia.mj.impl.pim.utils.NativeError;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class RepeatRule {
    public static final int APRIL = 0x100000;
    public static final int AUGUST = 0x1000000;
    public static final int COUNT = 32;
    public static final int DAILY = 16;
    public static final int DAY_IN_MONTH = 1;
    public static final int DAY_IN_WEEK = 2;
    public static final int DAY_IN_YEAR = 4;
    public static final int DECEMBER = 0x10000000;
    public static final int END = 64;
    public static final int FEBRUARY = 262144;
    public static final int FIFTH = 16;
    public static final int FIFTHLAST = 512;
    public static final int FIRST = 1;
    public static final int FOURTH = 8;
    public static final int FOURTHLAST = 256;
    public static final int FREQUENCY = 0;
    public static final int FRIDAY = 2048;
    public static final int INTERVAL = 128;
    public static final int JANUARY = 131072;
    public static final int JULY = 0x800000;
    public static final int JUNE = 0x400000;
    public static final int LAST = 32;
    public static final int MARCH = 524288;
    public static final int MAY = 0x200000;
    public static final int MONDAY = 32768;
    public static final int MONTH_IN_YEAR = 8;
    public static final int MONTHLY = 18;
    public static final int NOVEMBER = 0x8000000;
    public static final int OCTOBER = 0x4000000;
    public static final int SATURDAY = 1024;
    public static final int SECOND = 2;
    public static final int SECONDLAST = 64;
    public static final int SEPTEMBER = 0x2000000;
    public static final int SUNDAY = 65536;
    public static final int THIRD = 4;
    public static final int THIRDLAST = 128;
    public static final int THURSDAY = 4096;
    public static final int TUESDAY = 16384;
    public static final int WEDNESDAY = 8192;
    public static final int WEEK_IN_MONTH = 16;
    public static final int WEEKLY = 17;
    public static final int YEARLY = 19;
    private Finalizer iFinalizer;
    private int iRepeatRuleHandle;

    public RepeatRule() {
        PIMManager.getInstance();
        int[] error = new int[1];
        this.iRepeatRuleHandle = this._createRepeatRule(error);
        if (!NativeError.checkSuccess(error[0])) {
            throw new GenericException("General error:" + error[0]);
        }
        this.setShutdownListener();
        this.iFinalizer = this.registerForFinalization();
    }

    RepeatRule(int aRepeatRulehandle) {
        this.iRepeatRuleHandle = aRepeatRulehandle;
        this.setShutdownListener();
        this.iFinalizer = this.registerForFinalization();
    }

    Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                RepeatRule.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        if (this.iRepeatRuleHandle != 0) {
            this._dispose(this.iRepeatRuleHandle);
            this.iRepeatRuleHandle = 0;
        }
    }

    private void setShutdownListener() {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                if (RepeatRule.this.iRepeatRuleHandle != 0) {
                    RepeatRule.this._dispose(RepeatRule.this.iRepeatRuleHandle);
                    RepeatRule.this.iRepeatRuleHandle = 0;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration dates(long aStartDate, long aSubsetBeginning, long aSubsetEnding) {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            if (aSubsetBeginning > aSubsetEnding) {
                throw new IllegalArgumentException("Start date is greater than end date.");
            }
            int[] repeatDates = this._dates(this.iRepeatRuleHandle, aStartDate, aSubsetBeginning, aSubsetEnding);
            if (repeatDates == null) {
                throw new OutOfMemoryError();
            }
            long[] repeatDatesLong = PIMTools.intArrayToLongArray(repeatDates);
            return this.longArrayDatesToEnumeration(repeatDatesLong);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptDate(long aValue) {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            this._addExceptDate(this.iRepeatRuleHandle, aValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExceptDate(long aValue) {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            this._removeExceptDate(this.iRepeatRuleHandle, aValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getExceptDates() {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            int[] exceptDates = this._getExceptDates(this.iRepeatRuleHandle);
            if (exceptDates == null) {
                throw new OutOfMemoryError();
            }
            long[] exceptDatesLong = PIMTools.intArrayToLongArray(exceptDates);
            return this.longArrayDatesToEnumeration(exceptDatesLong);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int aField) {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            int[] error = new int[1];
            int value = this._getInt(this.iRepeatRuleHandle, aField, error);
            NativeError.handleRRFieldHandlingError(error[0], aField);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int aField, int aValue) {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            switch (aField) {
                case 0: {
                    if (aValue == 16 || aValue == 17 || aValue == 18 || aValue == 19) break;
                    throw new IllegalArgumentException("Invalid value for field FREQUENCY.");
                }
                case 128: {
                    if (aValue >= 1) break;
                    throw new IllegalArgumentException("Invalid value for field INTERVAL.");
                }
                case 1: {
                    if (aValue >= 1 && aValue <= 31) break;
                    throw new IllegalArgumentException("Invalid value for field DAY_IN_MONTH.");
                }
                case 2: {
                    if ((aValue & 0x10000) != 0 || (aValue & 0x8000) != 0 || (aValue & 0x4000) != 0 || (aValue & 0x2000) != 0 || (aValue & 0x1000) != 0 || (aValue & 0x800) != 0 || (aValue & 0x400) != 0) break;
                    throw new IllegalArgumentException("Invalid value for field DAY_IN_WEEK.");
                }
                case 4: {
                    if (aValue >= 1 && aValue <= 366) break;
                    throw new IllegalArgumentException("Invalid value for field DAY_IN_YEAR.");
                }
                case 8: {
                    if ((aValue & 0x20000) != 0 || (aValue & 0x40000) != 0 || (aValue & 0x80000) != 0 || (aValue & 0x100000) != 0 || (aValue & 0x200000) != 0 || (aValue & 0x400000) != 0 || (aValue & 0x800000) != 0 || (aValue & 0x1000000) != 0 || (aValue & 0x2000000) != 0 || (aValue & 0x4000000) != 0 || (aValue & 0x8000000) != 0 || (aValue & 0x10000000) != 0) break;
                    throw new IllegalArgumentException("Invalid value for field MONTH_IN_YEAR.");
                }
                case 16: {
                    if ((aValue & 1) != 0 || (aValue & 2) != 0 || (aValue & 4) != 0 || (aValue & 8) != 0 || (aValue & 0x10) != 0 || (aValue & 0x20) != 0 || (aValue & 0x40) != 0 || (aValue & 0x80) != 0 || (aValue & 0x100) != 0 || (aValue & 0x200) != 0) break;
                    throw new IllegalArgumentException("Invalid value for field WEEK_IN_MONTH.");
                }
                case 32: {
                    if (aValue >= 0) break;
                    throw new IllegalArgumentException("Invalid value for field COUNT.");
                }
                default: {
                    throw new IllegalArgumentException("Invalid field: " + aField);
                }
            }
            int[] error = new int[1];
            this._setInt(this.iRepeatRuleHandle, aField, aValue, error);
            NativeError.handleRRFieldHandlingError(error[0], aField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDate(int aField) {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            int[] error = new int[1];
            long value = this._getDate(this.iRepeatRuleHandle, aField, error);
            NativeError.handleRRFieldHandlingError(error[0], aField);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int aField, long aValue) {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            int[] error = new int[1];
            this._setDate(this.iRepeatRuleHandle, aField, aValue, error);
            NativeError.handleRRFieldHandlingError(error[0], aField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getFields() {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            int[] fields = this._getFields(this.iRepeatRuleHandle);
            if (fields == null) {
                throw new OutOfMemoryError();
            }
            return fields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object aObj) {
        RepeatRule repeatRule = this;
        synchronized (repeatRule) {
            RepeatRule compareRule;
            boolean retVal = false;
            if (aObj == null) {
                retVal = false;
            } else if (aObj instanceof RepeatRule && this.compareRepeatRuleFields(compareRule = (RepeatRule)aObj) && this.compareExceptionDates(compareRule)) {
                retVal = true;
            }
            return retVal;
        }
    }

    private boolean compareRepeatRuleFields(RepeatRule aRepeatRule) {
        int[] compareFields = aRepeatRule.getFields();
        int[] fields = this.getFields();
        if (fields.length != compareFields.length) {
            return false;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] != compareFields[i]) {
                return false;
            }
            if (fields[i] == 64) {
                Date endDate = new Date(this.getDate(64));
                Date endDateCompare = new Date(aRepeatRule.getDate(64));
                if (this.resetTimePortion(endDate).equals(this.resetTimePortion(endDateCompare))) continue;
                return false;
            }
            if (this.getInt(fields[i]) == aRepeatRule.getInt(fields[i])) continue;
            return false;
        }
        return true;
    }

    private boolean compareExceptionDates(RepeatRule aRepeatRule) {
        Enumeration compareExceptDates = aRepeatRule.getExceptDates();
        Enumeration exceptDates = this.getExceptDates();
        Vector exceptDatesVector = new Vector();
        while (exceptDates.hasMoreElements()) {
            exceptDatesVector.addElement(this.resetTimePortion((Date)exceptDates.nextElement()));
        }
        int searchIndex = -1;
        while (compareExceptDates.hasMoreElements()) {
            searchIndex = exceptDatesVector.indexOf(this.resetTimePortion((Date)compareExceptDates.nextElement()));
            if (searchIndex == -1) {
                return false;
            }
            exceptDatesVector.removeElementAt(searchIndex);
        }
        return exceptDatesVector.size() <= 0;
    }

    private Enumeration longArrayDatesToEnumeration(long[] aArray) {
        Vector retVal = new Vector(aArray.length);
        for (int i = 0; i < aArray.length; ++i) {
            retVal.addElement(new Date(aArray[i]));
        }
        return retVal.elements();
    }

    private Date resetTimePortion(Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        cal.set(9, 0);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    int nativeHandle() {
        return this.iRepeatRuleHandle;
    }

    void setNativePeer(int aRepeatRuleHandle) {
        this._dispose(this.iRepeatRuleHandle);
        this.iRepeatRuleHandle = aRepeatRuleHandle;
    }

    private native int _createRepeatRule(int[] var1);

    private native void _dispose(int var1);

    private native int[] _dates(int var1, long var2, long var4, long var6);

    private native void _addExceptDate(int var1, long var2);

    private native void _removeExceptDate(int var1, long var2);

    private native int[] _getExceptDates(int var1);

    private native int _getInt(int var1, int var2, int[] var3);

    private native void _setInt(int var1, int var2, int var3, int[] var4);

    private native long _getDate(int var1, int var2, int[] var3);

    private native void _setDate(int var1, int var2, long var3, int[] var5);

    private native int[] _getFields(int var1);
}

