/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import com.nokia.mj.impl.rms.FileStorage;
import com.nokia.mj.impl.rms.Storage;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordEnumerationImpl;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordStore {
    public static final int AUTHMODE_PRIVATE = 0;
    public static final int AUTHMODE_ANY = 1;
    private static Vector RECORD_STORE_LIST = new Vector();
    private static Object RS_LIST_SYNC = new Object();
    private String iName;
    private String iVendorName;
    private String iSuiteName;
    private int iOpenCount;
    private Storage iStorage;
    private Vector iListeners;
    Object iRsSync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecordStore(String aRecordStoreName) throws RecordStoreException, RecordStoreNotFoundException {
        if (aRecordStoreName == null) {
            throw new RecordStoreNotFoundException("Record store does not exist: " + aRecordStoreName);
        }
        Object object = RS_LIST_SYNC;
        synchronized (object) {
            RecordStore recordStore = RecordStore.findRecordStore(aRecordStoreName);
            if (recordStore != null) {
                throw new RecordStoreException("Cannot delete currently opened record store: " + aRecordStoreName);
            }
            Storage tmpStorage = RecordStore.getStorage(aRecordStoreName);
            tmpStorage.delete(aRecordStoreName);
        }
    }

    public static RecordStore openRecordStore(String aRecordStoreName, boolean aCreateIfNecessary) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        return RecordStore.openRecordStore(aRecordStoreName, aCreateIfNecessary, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordStore openRecordStore(String aRecordStoreName, boolean aCreateIfNecessary, int aAuthmode, boolean aWritable) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        if (aRecordStoreName.length() > 32 || aRecordStoreName.length() < 1) {
            throw new IllegalArgumentException("Record store name is invalid");
        }
        Object object = RS_LIST_SYNC;
        synchronized (object) {
            RecordStore recordStore = RecordStore.findRecordStore(aRecordStoreName);
            if (recordStore == null) {
                recordStore = new RecordStore(aRecordStoreName);
                recordStore.iStorage.open(aCreateIfNecessary, aAuthmode, aWritable);
                RECORD_STORE_LIST.addElement(recordStore);
            }
            ++recordStore.iOpenCount;
            return recordStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordStore openRecordStore(String aRecordStoreName, String aVendorName, String aSuiteName) throws RecordStoreException, RecordStoreNotFoundException {
        if (aRecordStoreName.length() > 32 || aRecordStoreName.length() < 1) {
            throw new IllegalArgumentException("Record store name is invalid");
        }
        Object object = RS_LIST_SYNC;
        synchronized (object) {
            RecordStore recordStore = RecordStore.findRecordStore(aRecordStoreName, aVendorName, aSuiteName);
            if (recordStore == null) {
                recordStore = new RecordStore(aRecordStoreName, aVendorName, aSuiteName);
                recordStore.iStorage.open(aVendorName, aSuiteName);
                RECORD_STORE_LIST.addElement(recordStore);
            }
            ++recordStore.iOpenCount;
            return recordStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int aAuthmode, boolean aWritable) throws RecordStoreException {
        Object object = this.iRsSync;
        synchronized (object) {
            if (aAuthmode != 0 && aAuthmode != 1) {
                throw new IllegalArgumentException("Access mode is invalid");
            }
            this.iStorage.setMode(aAuthmode, aWritable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            this.iListeners.removeAllElements();
            Object object2 = RS_LIST_SYNC;
            synchronized (object2) {
                --this.iOpenCount;
                if (this.iOpenCount == 0) {
                    RECORD_STORE_LIST.removeElement(this);
                    this.iStorage.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listRecordStores() {
        Object object = RS_LIST_SYNC;
        synchronized (object) {
            Storage tmpStorage = RecordStore.getStorage(null);
            return tmpStorage.listRecordStores();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws RecordStoreNotOpenException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() throws RecordStoreNotOpenException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iStorage.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRecords() throws RecordStoreNotOpenException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iStorage.getNumRecords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws RecordStoreNotOpenException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iStorage.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSizeAvailable() throws RecordStoreNotOpenException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iStorage.getSizeAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() throws RecordStoreNotOpenException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iStorage.getLastUpdateTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecordListener(RecordListener aListener) {
        Object object = this.iRsSync;
        synchronized (object) {
            if (!this.iListeners.contains(aListener)) {
                this.iListeners.addElement(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecordListener(RecordListener aListener) {
        Object object = this.iRsSync;
        synchronized (object) {
            if (this.iListeners.contains(aListener)) {
                this.iListeners.removeElement(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iStorage.getNextRecordID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRecord(byte[] aData, int aOffset, int aNumBytes) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            if (aNumBytes > 0 && aData == null) {
                throw new NullPointerException("Data cannot be null if data length is non-zero");
            }
            int recId = this.iStorage.addRecord(aData, aOffset, aNumBytes);
            this.notifyListenersAdded(recId);
            return recId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(int aRecordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            this.iStorage.deleteRecord(aRecordId);
            this.notifyListenersDeleted(aRecordId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordSize(int aRecordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iStorage.getRecordSize(aRecordId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecord(int aRecordId, byte[] aBuffer, int aOffset) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return this.iStorage.getRecord(aRecordId, aBuffer, aOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRecord(int aRecordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.iRsSync;
        synchronized (object) {
            int size = this.getRecordSize(aRecordId);
            if (size == 0) {
                return null;
            }
            byte[] buffer = new byte[size];
            this.iStorage.getRecord(aRecordId, buffer, 0);
            return buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecord(int aRecordId, byte[] aNewData, int aOffset, int aNumBytes) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            this.iStorage.setRecord(aRecordId, aNewData, aOffset, aNumBytes);
            this.notifyListenersChanged(aRecordId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordEnumeration enumerateRecords(RecordFilter aFilter, RecordComparator aComparator, boolean aKeepUpdated) throws RecordStoreNotOpenException {
        Object object = this.iRsSync;
        synchronized (object) {
            this.ensureOpen();
            return new RecordEnumerationImpl(this, aFilter, aComparator, aKeepUpdated);
        }
    }

    int[] getRecordIDs() {
        return this.iStorage.getRecordIDs();
    }

    private void ensureOpen() throws RecordStoreNotOpenException {
        if (this.iOpenCount < 1) {
            throw new RecordStoreNotOpenException("Record store must be open");
        }
    }

    private RecordStore(String aName) {
        this.iName = aName;
        this.iStorage = new FileStorage(aName);
        this.iListeners = new Vector();
        this.iRsSync = new Object();
        this.iVendorName = ApplicationInfo.getInstance().getVendor();
        this.iSuiteName = ApplicationInfo.getInstance().getSuiteName();
    }

    private RecordStore(String aName, String aVendorName, String aSuiteName) {
        this.iName = aName;
        this.iStorage = new FileStorage(aName);
        this.iListeners = new Vector();
        this.iRsSync = new Object();
        this.iVendorName = aVendorName;
        this.iSuiteName = aSuiteName;
    }

    private static RecordStore findRecordStore(String aRecordStoreName) {
        String vendor = ApplicationInfo.getInstance().getVendor();
        String suite = ApplicationInfo.getInstance().getSuiteName();
        return RecordStore.findRecordStore(aRecordStoreName, vendor, suite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RecordStore findRecordStore(String aRecordStoreName, String aVendorName, String aSuiteName) {
        Object object = RS_LIST_SYNC;
        synchronized (object) {
            int num = RECORD_STORE_LIST.size();
            for (int i = 0; i < num; ++i) {
                RecordStore rs = (RecordStore)RECORD_STORE_LIST.elementAt(i);
                if (!rs.iName.equals(aRecordStoreName) || !rs.iVendorName.equals(aVendorName) || !rs.iSuiteName.equals(aSuiteName)) continue;
                return rs;
            }
            return null;
        }
    }

    private static Storage getStorage(String aRecordStoreName) {
        return new FileStorage(aRecordStoreName);
    }

    private void notifyListenersAdded(int aRecordId) {
        for (int i = 0; i < this.iListeners.size(); ++i) {
            RecordListener listener = (RecordListener)this.iListeners.elementAt(i);
            listener.recordAdded(this, aRecordId);
        }
    }

    private void notifyListenersDeleted(int aRecordId) {
        for (int i = 0; i < this.iListeners.size(); ++i) {
            RecordListener listener = (RecordListener)this.iListeners.elementAt(i);
            listener.recordDeleted(this, aRecordId);
        }
    }

    private void notifyListenersChanged(int aRecordId) {
        for (int i = 0; i < this.iListeners.size(); ++i) {
            RecordListener listener = (RecordListener)this.iListeners.elementAt(i);
            listener.recordChanged(this, aRecordId);
        }
    }
}

