/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.midp.test.devcerttests;

import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.HttpsConnection;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;

public class DevCertTestMIDlet
extends MIDlet
implements Runnable,
CommandListener {
    private Form form;
    private Display display = Display.getDisplay((MIDlet)this);
    private Command testCmd;
    private Command exitCmd;
    private Command clearCmd;
    private ChoiceGroup testsGrp;
    private static final String testHttp = "HTTP";
    private static final String testHttps = "HTTPS";
    private static final String testContactListRead = "CONTACTLIST.READ";
    private static final String testContactListWrite = "CONTACTLIST.WRITE";
    private static final String[] tests = new String[]{"HTTP", "HTTPS", "CONTACTLIST.READ", "CONTACTLIST.WRITE"};
    private String httpUrl = "";
    private String httpsUrl;

    public DevCertTestMIDlet() {
        this.form = new Form("DevCertTM v1.0");
        this.testCmd = new Command("Test", 4, 1);
        this.clearCmd = new Command("Clear", 4, 1);
        this.exitCmd = new Command("Exit", 7, 1);
        this.form.addCommand(this.testCmd);
        this.form.addCommand(this.clearCmd);
        this.form.addCommand(this.exitCmd);
        this.testsGrp = new ChoiceGroup("Select test", 1, tests, null);
        this.form.append((Item)this.testsGrp);
        this.form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.form);
        this.getAppProperties();
    }

    public void getAppProperties() {
        try {
            this.httpUrl = this.getAppProperty("httpUrl");
            this.httpsUrl = this.getAppProperty("httpsUrl");
        }
        catch (Exception exception) {
            String string = exception.getClass().getName();
            this.form.append("Exception: " + string + ": " + exception.getMessage());
        }
    }

    public void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.form);
    }

    public void destroyApp(boolean bl) {
    }

    public void pauseApp() {
    }

    public void run() {
        try {
            String string = this.testsGrp.getString(this.testsGrp.getSelectedIndex());
            if (string.equals(testHttp)) {
                HttpConnection httpConnection = (HttpConnection)Connector.open((String)this.httpUrl);
                httpConnection.close();
                this.form.append("Test HTTP done.");
            } else if (string.equals(testHttps)) {
                HttpsConnection httpsConnection = (HttpsConnection)Connector.open((String)this.httpsUrl);
                httpsConnection.close();
                this.form.append("Test HTTPS done.");
            } else if (string.equals(testContactListRead)) {
                ContactList contactList = (ContactList)PIM.getInstance().openPIMList(1, 1);
                contactList.close();
                this.form.append("Test CONTACTLIST.READ done.");
            } else if (string.equals(testContactListWrite)) {
                ContactList contactList = (ContactList)PIM.getInstance().openPIMList(1, 2);
                contactList.close();
                this.form.append("Test CONTACTLIST.WRITE done.");
            }
        }
        catch (Exception exception) {
            String string = exception.getClass().getName();
            this.form.append("Exception: " + string + " " + exception.getMessage());
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCmd) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.clearCmd) {
            this.form.deleteAll();
            this.form.append((Item)this.testsGrp);
        } else if (command == this.testCmd) {
            new Thread(this).start();
        }
    }
}

