/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.connection.file.FileInputStream;
import com.ibm.oti.connection.socket.Socket;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.Jxe;
import com.ibm.oti.vm.MemInputStream;
import com.ibm.oti.vm.ZipStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Hashtable;
import java.util.Vector;

public final class VM {
    private static int[] types;
    private static Object[] cache;
    private static boolean[] isBoot;
    static Object cacheLock;
    private static boolean allowExit;
    private static boolean closeSockets;
    private static Vector shutdownClasses;
    private static final Class javaLangClass;
    private static final AppendToClassPathLock appendToClassPathLock;
    static final int CPE_TYPE_UNKNOWN = 0;
    static final int CPE_TYPE_DIRECTORY = 1;
    static final int CPE_TYPE_JAR = 2;
    static final int CPE_TYPE_TCP = 3;
    static final int CPE_TYPE_JXE = 4;
    static final int CPE_TYPE_UNUSABLE = 5;
    static final int CPE_TYPE_PALMDB = 6;
    static final int CPE_TYPE_ODC = 7;
    static final int CPE_TYPE_JXESL = 8;
    private static String[] restrictedPackages;
    private static String[] protectedPackages;
    private static Hashtable protectedClasses;

    static {
        cacheLock = new CacheLock();
        allowExit = true;
        closeSockets = false;
        shutdownClasses = new Vector(4);
        Class jlc = null;
        try {
            jlc = Class.forName("java.lang.Class");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        javaLangClass = jlc;
        appendToClassPathLock = new AppendToClassPathLock();
        restrictedPackages = new String[]{"java.", "javax.microedition.", "com.ibm.oti.", "com.ibm.j9.", "com.ibm.ive."};
        protectedPackages = new String[]{"com.ibm.oti.", "com.ibm.j9."};
        protectedClasses = new Hashtable();
        protectedClasses.put("java.lang.StackTraceElement", "");
        protectedClasses.put("java.util.GregorianCalendar", "");
        protectedClasses.put("java.util.SimpleTimeZone", "");
    }

    private VM() {
    }

    private static final native Class getStackClass(int var0);

    public static final boolean callerIsBootstrap() {
        Class caller = VM.getStackClass(2);
        if (caller == javaLangClass) {
            caller = VM.getStackClass(4);
        }
        return VM.isBootstrapClass(caller);
    }

    private static final native boolean isBootstrapClass(Class var0);

    public static native void dumpString(String var0);

    public static Class findAppClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    private static native int getBootClassPathCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeVM() {
        int count = VM.getClassPathCount();
        int bootCount = VM.getBootClassPathCount();
        Object object = cacheLock;
        synchronized (object) {
            types = new int[count];
            isBoot = new boolean[count];
            int i = 0;
            while (i < bootCount) {
                VM.isBoot[i] = true;
                ++i;
            }
            cache = new Object[count];
        }
    }

    public static void closeSockets() {
        closeSockets = true;
    }

    public static void addShutdownClass(Runnable cl) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        shutdownClasses.addElement(cl);
    }

    private static void shutdown() {
        int i = shutdownClasses.size() - 1;
        while (i >= 0) {
            ((Runnable)shutdownClasses.elementAt(i)).run();
            --i;
        }
        if (closeSockets) {
            Socket.closeOpenSockets();
        }
    }

    private static void cleanup() {
    }

    static final native int getClassPathEntryType(Object var0, int var1);

    static final native long getJxePointerFromClassPath(Object var0, int var1);

    static Jxe getJxeFromClassPath(Object classLoader, int cpIndex) {
        long pointer = VM.getJxePointerFromClassPath(classLoader, cpIndex);
        if (pointer == 0L) {
            return null;
        }
        Jxe jxe = new Jxe(pointer);
        return jxe;
    }

    private static void fillCache(int i) {
        VM.setTypesElement(i, VM.getClassPathEntryType(null, i));
        switch (VM.getTypes()[i]) {
            case 0: {
                VM.setTypesElement(i, 5);
                break;
            }
            case 1: {
                byte[] bytes = VM.getPathFromClassPath(i);
                VM.setCacheElement(i, bytes);
                return;
            }
            case 4: 
            case 8: {
                Jxe jxe = VM.getJxeFromClassPath(null, i);
                if (jxe != null) {
                    VM.setCacheElement(i, jxe);
                    return;
                }
                VM.setTypesElement(i, 5);
            }
        }
    }

    private static native long getPointerToNativeResourceJarImpl(byte[] var0, String var1, int[] var2);

    private static native long getPointerToNativeResourceImpl(int var0, String var1, int[] var2);

    static native void releasePointerToNativeResourceImpl(long var0);

    public static MemInputStream getResourceAsMemInputStream(String jarPath, String resName) {
        String sub;
        if (jarPath != null) {
            if (!VM.callerIsBootstrap()) {
                throw new SecurityException();
            }
            int[] size = new int[1];
            long memPtr = VM.getPointerToNativeResourceJarImpl(Util.getBytes(jarPath), resName, size);
            if (memPtr == 0L) {
                return null;
            }
            return new MemInputStream(memPtr, size[0]);
        }
        if (resName.length() >= 6 && (sub = resName.substring(resName.length() - 6)).toLowerCase().equals(".class")) {
            return null;
        }
        boolean bootClass = VM.isBootstrapClass(VM.getStackClass(2));
        int cacheLength = VM.getCache().length;
        int i = 0;
        while (i < cacheLength) {
            if (VM.getIsBoot()[i] == bootClass || bootClass) {
                if (VM.getTypes()[i] == 0 || VM.getTypes()[i] == 7) {
                    VM.fillCache(i);
                }
                switch (VM.getTypes()[i]) {
                    case 2: {
                        MemInputStream mis;
                        int[] size = new int[1];
                        long memPtr = VM.getPointerToNativeResourceImpl(i, resName, size);
                        if (memPtr == 0L || (mis = new MemInputStream(memPtr, size[0])) == null) break;
                        return mis;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static InputStream getResourceAsStream(String resName, boolean restrict) {
        if (resName.length() >= 6 && (sub = resName.substring(resName.length() - 6)).toLowerCase().equals(".class")) {
            return null;
        }
        bootClass = VM.isBootstrapClass(VM.getStackClass(2));
        cacheLength = VM.getCache().length;
        i = 0;
        while (i < cacheLength) {
            if (VM.getIsBoot()[i] == bootClass || bootClass && !restrict) {
                if (VM.getTypes()[i] == 0 || VM.getTypes()[i] == 7) {
                    VM.fillCache(i);
                }
                switch (VM.getTypes()[i]) {
                    case 1: {
                        path = (byte[])VM.getCache()[i];
                        resBytes = resName.getBytes();
                        name = new byte[path.length + resBytes.length];
                        System.arraycopy((Object)path, 0, (Object)name, 0, path.length);
                        System.arraycopy((Object)resBytes, 0, (Object)name, path.length, resBytes.length);
                        try {
                            in = new FileInputStream(name);
                            return in;
                        }
                        catch (IOException v0) {
                            break;
                        }
                    }
                    case 2: {
                        try {
                            stream = ZipStream.fromClassPath(i, resName);
                            if (stream == null) ** break;
                            return stream;
                        }
                        catch (IOException v1) {}
                        break;
                    }
                    case 4: 
                    case 8: {
                        result = ((Jxe)VM.getCache()[i]).getResourceAsStream(resName);
                        if (result == null) break;
                        return result;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean allowExit() {
        return allowExit;
    }

    public static void stopExit() {
        allowExit = false;
    }

    public static void allowMidpExit() {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        allowExit = true;
    }

    static native int getClassPathCount();

    static native byte[] getPathFromClassPath(int var0);

    public static synchronized void loadLibrary(String libName) throws IOException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        VM.loadLibrary(libName, System.getProperty("com.ibm.oti.vm.bootstrap.library.path"));
    }

    private static void loadLibrary(String libName, String libraryPath) throws IOException {
        byte[] message = VM.loadLibraryWithPath(Util.getBytes(libName), libraryPath == null ? null : Util.getBytes(libraryPath));
        if (message != null) {
            String error;
            try {
                error = Util.convertFromUTF8(message, 0, message.length);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                error = Util.toString(message);
            }
            throw new IOException(String.valueOf(libName) + " (" + error + ")");
        }
    }

    private static native byte[] loadLibraryWithPath(byte[] var0, byte[] var1);

    public static native void localGC();

    public static native void globalGC();

    public static native void runFinalization();

    public static void runFinalizersOnExit(boolean flag) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        VM.runFinalizersOnExitImpl(flag);
    }

    private static native void runFinalizersOnExitImpl(boolean var0);

    public static final boolean useNatives() {
        return VM.useNativesImpl();
    }

    private static final native boolean useNativesImpl();

    public static void checkRestrictedPackage(Class checkClass) {
        if (!VM.isBootstrapClass(checkClass)) {
            String className = checkClass.getName();
            int i = 0;
            while (i < restrictedPackages.length) {
                if (className.startsWith(restrictedPackages[i])) {
                    throw new SecurityException(Msg.getString("K01d2", restrictedPackages[i], className));
                }
                ++i;
            }
        }
    }

    public static synchronized void addRestrictedPackages(String[] packageNames) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        int oldLength = restrictedPackages.length;
        String[] newList = new String[oldLength + packageNames.length];
        System.arraycopy((Object)restrictedPackages, 0, (Object)newList, 0, oldLength);
        int i = 0;
        while (i < packageNames.length) {
            newList[oldLength + i] = packageNames[i];
            ++i;
        }
        restrictedPackages = newList;
    }

    public static void checkProtectedPackage(String className) throws ClassNotFoundException {
        if (protectedClasses.containsKey(className)) {
            throw new ClassNotFoundException(className);
        }
        int i = 0;
        while (i < protectedPackages.length) {
            if (className.startsWith(protectedPackages[i])) {
                throw new ClassNotFoundException(Msg.getString("K01d2", protectedPackages[i], className));
            }
            ++i;
        }
    }

    public static synchronized void addProtectedPackages(String[] packageNames) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        int oldLength = protectedPackages.length;
        String[] newList = new String[oldLength + packageNames.length];
        System.arraycopy((Object)protectedPackages, 0, (Object)newList, 0, oldLength);
        int i = 0;
        while (i < packageNames.length) {
            newList[oldLength + i] = packageNames[i];
            ++i;
        }
        protectedPackages = newList;
    }

    public static native boolean enableJIT();

    public static String setSystemProperty(String prop, String value) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        return VM.setProperty(prop, value);
    }

    private static native String setProperty(String var0, String var1);

    public static void setDaemonThread(Thread thread) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        if (!VM.setDaemonThreadImpl(thread)) {
            throw new IllegalThreadStateException();
        }
    }

    private static native boolean setDaemonThreadImpl(Thread var0);

    public static void enableFinalization(Class aClass) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        VM.enableFinalizationImpl(aClass);
    }

    private static final native void enableFinalizationImpl(Class var0);

    public static String[] getHttpProxyParms() {
        return VM.getHttpProxyImpl();
    }

    private static native String[] getHttpProxyImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendToClassPath(String classPathAdditions) {
        AppendToClassPathLock appendToClassPathLock = VM.appendToClassPathLock;
        synchronized (appendToClassPathLock) {
            boolean succeeded = false;
            if (!VM.callerIsBootstrap()) {
                throw new SecurityException();
            }
            String oldClassPath = System.getProperty("java.class.path");
            String separator = System.getProperty("path.separator");
            String newClassPath = String.valueOf(oldClassPath) + (classPathAdditions.startsWith(separator) ? "" : separator) + classPathAdditions;
            if (VM.appendToCPNativeImpl(classPathAdditions, newClassPath) && !VM.isApplicationClassLoaderPresent()) {
                VM.updateCache();
                succeeded = true;
            }
            return succeeded;
        }
    }

    public static int contractOldSpaceFully() {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        return VM.contractOldSpaceFullyImpl();
    }

    public static int expandOldSpace(int expandAmount) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        return VM.expandOldSpaceImpl(expandAmount);
    }

    private static native int contractOldSpaceFullyImpl();

    private static native int expandOldSpaceImpl(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCache() {
        int count = VM.getClassPathCount();
        int bootCount = VM.getBootClassPathCount();
        Object[] newCache = new Object[count];
        int[] newTypes = new int[count];
        Object object = cacheLock;
        synchronized (object) {
            System.arraycopy((Object)cache, 0, (Object)newCache, 0, cache.length);
            cache = newCache;
            System.arraycopy((Object)types, 0, (Object)newTypes, 0, types.length);
            types = newTypes;
            isBoot = new boolean[count];
            int i = 0;
            while (i < bootCount) {
                VM.isBoot[i] = true;
                ++i;
            }
        }
    }

    private static native boolean appendToCPNativeImpl(String var0, String var1);

    private static native boolean isApplicationClassLoaderPresent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getTypes() {
        Object object = cacheLock;
        synchronized (object) {
            return types;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTypesElement(int i, int value) {
        Object object = cacheLock;
        synchronized (object) {
            VM.types[i] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getCache() {
        Object object = cacheLock;
        synchronized (object) {
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCacheElement(int i, Object value) {
        Object object = cacheLock;
        synchronized (object) {
            VM.cache[i] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean[] getIsBoot() {
        Object object = cacheLock;
        synchronized (object) {
            return isBoot;
        }
    }

    private static class CacheLock {
        CacheLock() {
        }
    }

    private static class AppendToClassPathLock {
        AppendToClassPathLock() {
        }
    }
}

