/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.bluetooth;

import com.nokia.mj.impl.bluetooth.utils.BluetoothStateCheck;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;

public class BTPlatformControl
implements BluetoothStateCheck {
    static final int BT_GIAC = 10390323;
    static final int BT_LIAC = 10390272;
    static final int BT_HIDDEN = 0;

    public boolean checkDevicePowerOn(String aAppName, boolean aIsStaticReg) {
        return BTPlatformControl.setBTPowerOn(aAppName, aIsStaticReg);
    }

    public boolean checkDeviceDiscoverability(String aAppName, boolean aIsStaticReg) {
        return BTPlatformControl.setDiscoverabilityGIAC(aAppName, aIsStaticReg);
    }

    public static boolean setBTPowerOn(String aAppName, boolean aIsStaticReg) {
        Logger.LOG(19, 4, "# BTPlatformControl::setBTPowerOn");
        if (BTPlatformControl._isPowerOn()) {
            return true;
        }
        boolean result = BTPlatformControl._promptPowerOn(aAppName, aIsStaticReg);
        if (!result) {
            Logger.WLOG(19, "User refused Bluetooth Power on.");
            return false;
        }
        return BTPlatformControl._setPowerOn();
    }

    public static boolean setDiscoverabilityGIAC(String aAppName, boolean aIsStaticReg) {
        Logger.LOG(19, 4, "# BTPlatformControl::setDiscoverabilityGIAC");
        if (BTPlatformControl._getBluetoothDiscoverable() == 10390323) {
            return true;
        }
        boolean result = BTPlatformControl._promptVisibilityChange(aAppName, aIsStaticReg);
        if (!result) {
            Logger.WLOG(19, "User refused Bluetooth Visibility change.");
            return false;
        }
        return BTPlatformControl._setBluetoothDiscoverable(10390323);
    }

    public static native String _getBluetoothAddress();

    public static native String _getBluetoothName();

    public static native int _getBluetoothDeviceClass();

    public static native int _getBluetoothDiscoverable();

    public static native boolean _setBluetoothDiscoverable(int var0);

    public static native boolean _isPowerOn();

    public static native String _getProperty(int var0);

    public static native int _setServiceClasses(int var0);

    private static native boolean _setPowerOn();

    private static native boolean _promptPowerOn(String var0, boolean var1);

    private static native boolean _promptVisibilityChange(String var0, boolean var1);

    static {
        try {
            Jvm.loadSystemLibrary("javabluetoothcommons");
        }
        catch (Exception e) {
            Logger.ELOG(19, "Unable to load JavaBluetoothCommons.");
        }
    }
}

