/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.bluetooth.utils;

import com.nokia.mj.impl.utils.Logger;

public class DebugLog {
    private static final int COMPONENT_ID = 19;

    public static void log(String aMsg) {
        if (Logger.Activated[19]) {
            Logger.LOG(19, 4, aMsg);
        }
    }

    public static void logWarning(String aMsg) {
        if (Logger.Activated[19]) {
            Logger.LOG(19, 2, aMsg);
        }
    }

    public static void logWarning(String aMsg, Throwable aThrowable) {
        if (!Logger.Activated[19]) {
            return;
        }
        DebugLog.logThrowable(2, aMsg, aThrowable);
    }

    public static void logError(String aMsg) {
        if (Logger.Activated[19]) {
            Logger.LOG(19, 1, aMsg);
        }
    }

    public static void logError(String aMsg, Throwable aThrowable) {
        if (!Logger.Activated[19]) {
            return;
        }
        DebugLog.logThrowable(1, aMsg, aThrowable);
    }

    private static void logThrowable(int aLogLevel, String aMsg, Throwable aThrowable) {
        if (!Logger.Activated[19]) {
            return;
        }
        if (aThrowable == null) {
            Logger.LOG(19, aLogLevel, aMsg);
        } else {
            Logger.LOG(19, aLogLevel, aMsg, aThrowable);
        }
    }

    public static boolean isDebugEnabled() {
        return Logger.Activated[19];
    }

    public static void setDebugEnabled() {
    }

    public static void debug(String message) {
        DebugLog.log(message);
    }

    public static void debug(String message, String v) {
        DebugLog.log(message + " " + v);
    }

    public static void debug(String message, Throwable t) {
        DebugLog.logError(message, t);
    }

    public static void debug(String message, Object obj) {
        DebugLog.log(message + " " + obj.toString());
    }

    public static void debug(String message, String v, String v2) {
        DebugLog.log(message + " " + v + " " + v2);
    }

    public static void debug(String message, long v) {
        DebugLog.log(message + " " + String.valueOf(v));
    }

    public static void debug0x(String message, long v) {
        DebugLog.log(message + " 0x" + DebugLog.toHexString(v));
    }

    public static void debug0x(String message, String s, long v) {
        DebugLog.log(message + " " + s + " 0x" + DebugLog.toHexString(v));
    }

    public static void debug(String message, boolean v) {
        DebugLog.log(message + " " + v);
    }

    public static void debug(String message, byte[] data) {
        DebugLog.debug(message, data, 0, data == null ? 0 : data.length);
    }

    public static void debug(String message, byte[] data, int off, int len) {
        StringBuffer buf = new StringBuffer();
        if (data == null) {
            buf.append(" null byte[]");
        } else {
            buf.append(" [");
            for (int i = off; i < off + len; ++i) {
                if (i != off) {
                    buf.append(", ");
                }
                buf.append(new Byte(data[i]).toString());
            }
            buf.append("]");
            if (len > 4) {
                buf.append(" ").append(len);
            }
        }
        DebugLog.log(message + buf.toString());
    }

    public static void debug(String message, int[] data) {
        DebugLog.debug(message, data, 0, data == null ? 0 : data.length);
    }

    public static void debug(String message, int[] data, int off, int len) {
        StringBuffer buf = new StringBuffer();
        if (data == null) {
            buf.append(" null int[]");
        } else {
            buf.append(" [");
            for (int i = off; i < off + len; ++i) {
                if (i != off) {
                    buf.append(", ");
                }
                buf.append(Integer.toString(data[i]));
            }
            buf.append("]");
            if (len > 4) {
                buf.append(" ").append(len);
            }
        }
        DebugLog.log(message + buf.toString());
    }

    public static void nativeDebugCallback(String fileName, int lineN, String message) {
        try {
            if (fileName != null && fileName.startsWith(".\\")) {
                fileName = fileName.substring(2);
            }
            DebugLog.debugNative(fileName + ":" + lineN, message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void debugNative(String location, String message) {
        DebugLog.log(message + "\n\t  " + location);
    }

    public static void error(String message) {
        DebugLog.logError(message);
    }

    public static void error(String message, long v) {
        DebugLog.logError(message + " " + v);
    }

    public static void error(String message, String v) {
        DebugLog.logError(message + " " + v);
    }

    public static void error(String message, Throwable t) {
        DebugLog.logError(message, t);
    }

    public static void fatal(String message) {
        DebugLog.logError(message);
    }

    public static void fatal(String message, Throwable t) {
        DebugLog.logError(message, t);
    }

    public static void addAppender(LoggerAppender newAppender) {
    }

    public static void removeAppender(LoggerAppender newAppender) {
    }

    private static String toHexString(long l) {
        StringBuffer buf = new StringBuffer();
        String lo = Integer.toHexString((int)l);
        if (l > 0xFFFFFFFFL) {
            String hi = Integer.toHexString((int)(l >> 32));
            buf.append(hi);
            for (int i = lo.length(); i < 8; ++i) {
                buf.append('0');
            }
        }
        buf.append(lo);
        return buf.toString();
    }

    public static interface LoggerAppenderExt
    extends LoggerAppender {
        public boolean isLogEnabled(int var1);
    }

    public static interface LoggerAppender {
        public void appendLog(int var1, String var2, Throwable var3);
    }
}

