/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.bluetooth.utils;

import com.intel.bluetooth.UtilsStringTokenizer;
import com.nokia.mj.impl.bluetooth.utils.BluetoothStateCheck;
import com.nokia.mj.impl.bluetooth.utils.DebugLog;
import java.util.Hashtable;

public class PushUrlValidator {
    private static int ADDRESS_LENGTH = 12;
    private static int UUID_LENGTH = 32;
    private static int MAX_BLACKLIST_COUNT = 1024;
    private static final String AUTHENTICATE = "authenticate";
    private static final String AUTHORIZE = "authorize";
    private static final String ENCRYPT = "encrypt";

    public static String validParamName(Hashtable map, String paramName) {
        String validName = (String)map.get(paramName.toLowerCase());
        if (validName != null) {
            return validName;
        }
        return null;
    }

    public static void validateParams(Hashtable aProperty, UtilsStringTokenizer tok) {
        DebugLog.debug(" +  PushUrlValidator: validateParams()");
        Hashtable values = new Hashtable();
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            int equals = t.indexOf(61);
            if (equals > -1) {
                String param = t.substring(0, equals);
                String value = t.substring(equals + 1);
                String validName = PushUrlValidator.validParamName(aProperty, param);
                if (validName != null) {
                    String hasValue = (String)values.get(validName);
                    if (hasValue != null && !hasValue.equals(value)) {
                        DebugLog.error(" -  PushUrlValidator: Validate(): duplicate param [" + param + "] value [" + value + "]");
                        throw new IllegalArgumentException("duplicate param [" + param + "] value [" + value + "]");
                    }
                    values.put(validName, value);
                    continue;
                }
                DebugLog.error(" -  PushUrlValidator: Validate(): invalid param [" + param + "] value [" + value + "]");
                throw new IllegalArgumentException("invalid param [" + param + "] value [" + value + "]");
            }
            DebugLog.error(" -  PushUrlValidator: Validate(): invalid param [" + t + "]");
            throw new IllegalArgumentException("invalid param [" + t + "]");
        }
        Object authenticate = values.get(AUTHENTICATE);
        Object encrypt = values.get(ENCRYPT);
        Object authorize = values.get(AUTHORIZE);
        if (authenticate != null && authenticate.toString().equalsIgnoreCase("false") && encrypt != null && encrypt.toString().equalsIgnoreCase("true")) {
            DebugLog.error(" -  PushUrlValidator: Validate(): invalid params authenticate[" + authenticate + "] encrypt [" + encrypt + "]");
            throw new IllegalArgumentException("invalid params ");
        }
        if (authenticate != null && authenticate.toString().equalsIgnoreCase("false") && authorize != null && authorize.toString().equalsIgnoreCase("true")) {
            DebugLog.error(" -  PushUrlValidator: Validate(): invalid params authenticate[" + authenticate + "] authorize [" + authorize + "]");
            throw new IllegalArgumentException("invalid params ");
        }
        DebugLog.debug(" -  PushUrlValidator: validateParams()");
    }

    public static void validateFilterParams(Hashtable aProperty, UtilsStringTokenizer tok) {
        DebugLog.debug("+  PushUrlValidator: validateFilterParams");
        int state = 0;
        int blacklistFilterCounter = 0;
        boolean isAllowedSenderCompleted = false;
        while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 0: {
                    state = 1;
                    PushUrlValidator.checkAddressLength(nextTok);
                    PushUrlValidator.checkHexDig(nextTok);
                    break;
                }
                case 1: {
                    int equals = nextTok.indexOf(61);
                    if (equals < 0) {
                        String paramName = PushUrlValidator.validParamName(aProperty, nextTok);
                        if (isAllowedSenderCompleted || null == paramName || paramName.equalsIgnoreCase("BlackList")) {
                            throw new IllegalArgumentException();
                        }
                        isAllowedSenderCompleted = true;
                        break;
                    }
                    String param = nextTok.substring(0, equals);
                    if (!param.equalsIgnoreCase("BlackList")) {
                        throw new IllegalArgumentException("Illegal filter argument");
                    }
                    state = 2;
                    nextTok = nextTok.substring(equals + 1);
                }
                case 2: {
                    if (blacklistFilterCounter >= MAX_BLACKLIST_COUNT) {
                        throw new IllegalArgumentException("Too many BlackList entries");
                    }
                    PushUrlValidator.checkAddressLength(nextTok);
                    PushUrlValidator.checkHexDig(nextTok);
                    ++blacklistFilterCounter;
                }
            }
        }
        DebugLog.debug("-  PushUrlValidator: validateFilterParams");
    }

    public static void checkAddressLength(String aAddress) {
        if (null == aAddress || aAddress.length() > ADDRESS_LENGTH) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkUuidLength(String aUuid) {
        if (null == aUuid || aUuid.length() > UUID_LENGTH) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkHexDig(String aString) {
        DebugLog.debug(" +  PushUrlValidator: checkHexDig(): String: " + aString);
        if (0 == aString.length()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < aString.length(); ++i) {
            char c = aString.charAt(i);
            if (c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || c >= '0' && c <= '9' || c == '?' || c == '*') continue;
            throw new IllegalArgumentException();
        }
        DebugLog.debug(" -  PushUrlValidator: checkHexDig()");
    }

    public static void checkPowerAndDiscoverability(String aAppName, boolean aIsStaticReg) {
        try {
            Class stateCheck = Class.forName("com.nokia.mj.impl.bluetooth.BTPlatformControl");
            BluetoothStateCheck stateChecker = (BluetoothStateCheck)stateCheck.newInstance();
            boolean ready = true;
            if (!stateChecker.checkDevicePowerOn(aAppName, aIsStaticReg)) {
                DebugLog.debug(" PushUrlValidator:checkPowerAndDiscoverability Couldn't Switch Power ON");
                ready = false;
            }
            if (!stateChecker.checkDeviceDiscoverability(aAppName, aIsStaticReg)) {
                DebugLog.debug(" PushUrlValidator:checkPowerAndDiscoverability Couldn't Turn Discoverability Mode");
                ready = false;
            }
            if (!ready) {
                DebugLog.debug(" PushUrlValidator:checkPowerAndDiscoverability Unable to power on bluetooth");
                throw new IllegalArgumentException("Unable to power on bluetooth");
            }
        }
        catch (Exception ex) {
            DebugLog.debug("  PushUrlValidator:checkPowerAndDiscoverability Unable to switch on bluetooth Err:" + ex.getMessage());
            throw new IllegalArgumentException("Unable to switch on Bluetooth");
        }
    }
}

