/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.datagram;

import com.nokia.mj.impl.datagram.DatagramByteArrayOutStreamAdapter;
import com.nokia.mj.impl.gcf.utils.UrlParser;
import com.nokia.mj.impl.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Datagram;

public class DatagramImpl
implements Datagram {
    private byte[] iBuffer;
    private int iBufLength;
    private int iBufOffset;
    private String iAddress;
    private DataOutputStream iDataOutput;
    private DataInputStream iDataInput;
    private DatagramByteArrayOutStreamAdapter iByteOStreamAdapter;
    private static final int MAX_DATAGRAM_SIZE = 65535;

    private void validateParameters(byte[] aBuf, int aOffset, int aLength) {
        if (aLength < 0 || aOffset < 0 || aBuf == null || aLength > 65535 || aLength > aBuf.length - aOffset) {
            throw new IllegalArgumentException("Invalid argument in newDatagram method");
        }
    }

    public DatagramImpl(byte[] aBuf, int aSize, String aAddress) throws IOException {
        this.validateParameters(aBuf, 0, aSize);
        this.iBuffer = aBuf;
        this.iBufLength = aSize;
        this.iBufOffset = 0;
        this.iByteOStreamAdapter = new DatagramByteArrayOutStreamAdapter(aBuf);
        ByteArrayInputStream tmpins = new ByteArrayInputStream(aBuf, 0, aSize);
        this.iDataInput = new DataInputStream(tmpins);
        this.iDataOutput = new DataOutputStream(this.iByteOStreamAdapter);
        this.iAddress = aAddress;
    }

    public String getAddress() {
        return this.iAddress;
    }

    public byte[] getData() {
        return this.iBuffer;
    }

    public int getLength() {
        return this.iBufLength;
    }

    public int getOffset() {
        return this.iBufOffset;
    }

    public void setAddress(String addr) throws IOException {
        if (addr == null || !addr.startsWith("datagram://")) {
            throw new IllegalArgumentException("Invalid URL: " + addr);
        }
        UrlParser tmp = new UrlParser(addr);
        this.iAddress = addr;
    }

    public void setAddress(Datagram reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Datagram is null");
        }
        String addr = reference.getAddress();
        if (addr == null) {
            throw new IllegalArgumentException("Invalid URL: " + addr);
        }
        Logger.LOG(14, 4, "SetAddress(datagram) : addr = " + addr);
        this.iAddress = addr;
    }

    public void setLength(int len) {
        this.setData(this.iBuffer, this.iBufOffset, len);
    }

    public void setData(byte[] buffer, int offset, int len) {
        this.validateParameters(buffer, offset, len);
        this.iBuffer = buffer;
        this.iBufLength = len;
        this.iBufOffset = offset;
        this.iByteOStreamAdapter = new DatagramByteArrayOutStreamAdapter(buffer);
        ByteArrayInputStream tmpins = new ByteArrayInputStream(buffer, offset, len);
        this.iDataInput = new DataInputStream(tmpins);
        this.iDataOutput = new DataOutputStream(this.iByteOStreamAdapter);
    }

    public void reset() {
        this.iDataInput = new DataInputStream(new ByteArrayInputStream(this.iBuffer, 0, 0));
        this.iByteOStreamAdapter.reset();
        this.iDataOutput = new DataOutputStream(this.iByteOStreamAdapter);
        this.iBufOffset = 0;
        this.iBufLength = 0;
    }

    public void write(int b) throws IOException {
        try {
            this.iDataOutput.write(b);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void write(byte[] b) throws IOException {
        try {
            this.iDataOutput.write(b);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.iDataOutput.write(b, off, len);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        try {
            this.iDataOutput.writeBoolean(v);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeByte(int v) throws IOException {
        try {
            this.iDataOutput.writeByte(v);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeShort(int v) throws IOException {
        try {
            this.iDataOutput.writeShort(v);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeChar(int v) throws IOException {
        try {
            this.iDataOutput.writeChar(v);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeInt(int v) throws IOException {
        try {
            this.iDataOutput.writeInt(v);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeLong(long v) throws IOException {
        try {
            this.iDataOutput.writeLong(v);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeFloat(float v) throws IOException {
        try {
            this.iDataOutput.writeFloat(v);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeDouble(double v) throws IOException {
        try {
            this.iDataOutput.writeDouble(v);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeChars(String s) throws IOException {
        try {
            this.iDataOutput.writeChars(s);
            this.iBufLength = this.iByteOStreamAdapter.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void writeUTF(String s) throws IOException {
        try {
            Logger.LOG(14, 4, "writeUTf - s = " + s + "s.size = " + s.length());
            this.iDataOutput.writeUTF(s);
            Logger.LOG(14, 4, "iDataOutput.writeUTF success");
            this.iBufLength = this.iByteOStreamAdapter.size();
            Logger.LOG(14, 4, "iByteOStreamAdapter.size()success");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Datagram buffer size exceeded");
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.iDataInput.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.iDataInput.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.iDataInput.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.iDataInput.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.iDataInput.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.iDataInput.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.iDataInput.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.iDataInput.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.iDataInput.readChar();
    }

    public int readInt() throws IOException {
        return this.iDataInput.readInt();
    }

    public long readLong() throws IOException {
        return this.iDataInput.readLong();
    }

    public float readFloat() throws IOException {
        return this.iDataInput.readFloat();
    }

    public double readDouble() throws IOException {
        return this.iDataInput.readDouble();
    }

    public String readUTF() throws IOException {
        return this.iDataInput.readUTF();
    }
}

