/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.fileutils.URLUTF8Encoder;

public class FileUTF8Handler {
    public static String decode(String iEscapedUrl) {
        String decoded = iEscapedUrl;
        FileUTF8Handler.validateUnescapedUrl(decoded);
        if (iEscapedUrl.indexOf("%") != -1) {
            decoded = FileUTF8Handler.unescape(iEscapedUrl);
        }
        return decoded;
    }

    public static String encode(String iUnescapedUrl) {
        try {
            return URLUTF8Encoder.encode(FileUTF8Handler.decode(iUnescapedUrl));
        }
        catch (Exception exception) {
            return iUnescapedUrl;
        }
    }

    private static boolean isValidHexDigit(char aChar) {
        return Character.isDigit(aChar) || aChar >= 'a' && aChar <= 'f' || aChar >= 'A' && aChar <= 'F';
    }

    private static void validateUnescapedUrl(String aUrl) {
        boolean isUnescaped = false;
        char charip1 = '\u0000';
        char charip2 = '\u0000';
        try {
            for (int i = 0; i < aUrl.length(); ++i) {
                if (aUrl.charAt(i) == '%') {
                    isUnescaped = true;
                    charip1 = aUrl.charAt(i + 1);
                    charip2 = aUrl.charAt(i + 2);
                    if (FileUTF8Handler.isValidHexDigit(charip1) && FileUTF8Handler.isValidHexDigit(charip2)) continue;
                    throw new IllegalArgumentException();
                }
                if (aUrl.charAt(i) <= '\u007f' || !isUnescaped) continue;
                throw new IllegalArgumentException();
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException();
        }
    }

    public static String unescape(String s) {
        StringBuffer sbuf = new StringBuffer("");
        int l = s.length();
        int ch = -1;
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            int b;
            char c = s.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    ch = s.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                case '+': {
                    b = 32;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more != 0) continue;
                sbuf.append((char)sumb);
                continue;
            }
            if ((b & 0x80) == 0) {
                sbuf.append((char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
                continue;
            }
            if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
                continue;
            }
            if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
                continue;
            }
            if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
                continue;
            }
            sumb = b & 1;
            more = 5;
        }
        return sbuf.toString();
    }
}

