/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.utils;

import com.nokia.mj.impl.utils.Logger;

public class UrlParser {
    public String uri = null;
    public String scheme = null;
    public String authority = null;
    public String path = null;
    public String query = null;
    public String fragment = null;
    public String userinfo = null;
    public String host = null;
    public String portString = null;
    public static final int NOT_SPECIFIED = -1;
    public int port = -1;
    private int startScheme = 0;
    private int endScheme = 0;
    private int startAuthority = 0;
    private int endAuthority = 0;
    private int startPath = 0;
    private int endPath = 0;
    private int startQuery = 0;
    private int endQuery = 0;
    private int startFragment = 0;
    private int endFragment = 0;
    private int startPort = 0;
    private int endUserinfo = 0;
    private int startHost = 0;
    private int endHost = 0;
    private int doubleSlash = 0;
    private boolean isPath = true;
    private boolean isQuery = true;
    private boolean isFragment = true;
    private boolean doubleColon = false;
    private boolean isPortNumber = true;

    public UrlParser(String absoluteUri) {
        Logger.LOG(14, 4, "UrlParser(): uri = " + absoluteUri);
        String partialUri = null;
        this.uri = absoluteUri;
        this.endScheme = this.uri.indexOf(":", this.startScheme);
        if (this.endScheme == -1) {
            throw new IllegalArgumentException("Invalid url: " + absoluteUri);
        }
        if (this.endScheme > this.startScheme) {
            this.scheme = this.uri.substring(this.startScheme, this.endScheme);
        }
        if (this.endScheme == this.uri.length() - 1) {
            return;
        }
        partialUri = this.uri.substring(this.endScheme + 1);
        if (!partialUri.startsWith("//")) {
            throw new IllegalArgumentException("Invalid url: " + absoluteUri);
        }
        if (this.uri.charAt(this.endScheme + 1) == '/' && this.uri.charAt(this.endScheme + 2) == '/') {
            this.doubleSlash = this.endScheme + 1;
            if (this.endScheme > this.startScheme) {
                this.scheme = this.uri.substring(this.startScheme, this.endScheme);
            }
        }
        this.parse(absoluteUri);
        Logger.LOG(14, 4, "scheme : " + this.scheme + "host: " + this.host + "port: " + this.port + "authority: " + this.authority + "query: " + this.query + "fragment: " + this.fragment);
    }

    public UrlParser(String scheme, String relativeUri) {
        Logger.LOG(14, 4, "partial uri");
        this.uri = relativeUri;
        this.scheme = scheme;
        if (!this.uri.startsWith("//")) {
            throw new IllegalArgumentException("Invalid Url: " + scheme + ":" + relativeUri);
        }
        this.parse(scheme + ":" + relativeUri);
    }

    private void parse(String aUri) {
        this.startAuthority = this.doubleSlash > 0 ? this.endScheme + 3 : this.endScheme + 2;
        Logger.LOG(14, 4, "uri = " + this.uri + " starauth = " + this.startAuthority);
        int index = this.uri.indexOf(47, this.startAuthority);
        if (index == -1) {
            this.isPath = false;
            if (this.uri.indexOf(63, this.startAuthority) == -1) {
                this.isQuery = false;
                if (this.uri.indexOf(35, this.startAuthority) == -1) {
                    this.isFragment = false;
                    this.endAuthority = this.uri.length();
                } else {
                    this.endAuthority = this.uri.indexOf(35, this.startAuthority);
                }
            } else {
                this.endAuthority = this.uri.indexOf(63, this.startAuthority);
            }
        } else {
            this.endAuthority = this.uri.indexOf(47, this.startAuthority);
        }
        String bang = "bang";
        Logger.LOG(14, 4, "startauth = " + this.startAuthority + "  endauth = " + this.endAuthority);
        if (this.endAuthority == this.startAuthority) {
            throw new IllegalArgumentException("Invalid url: " + aUri);
        }
        if (this.endAuthority != -1 && this.startAuthority != -1 && this.endAuthority > this.startAuthority) {
            this.authority = this.uri.substring(this.startAuthority, this.endAuthority);
        }
        Logger.LOG(14, 4, "authority = " + this.authority);
        this.endUserinfo = this.authority.indexOf(64, 0);
        if (this.endUserinfo != -1) {
            if (this.endUserinfo > 0) {
                this.userinfo = this.authority.substring(0, this.endUserinfo);
            }
            this.startHost = this.endUserinfo + 1;
        } else {
            this.startHost = 0;
        }
        index = this.authority.indexOf(93);
        if (index != -1) {
            this.endHost = index;
            this.startPort = this.authority.indexOf(58, this.endHost);
        } else {
            this.startPort = this.authority.indexOf(58);
        }
        if (this.startPort != -1) {
            ++this.startPort;
            if (this.authority.length() > this.startPort) {
                Logger.LOG(14, 4, "startPort = " + this.startPort + "endAuthority = " + this.endAuthority);
            }
            this.portString = this.authority.substring(this.startPort, this.authority.length());
            Logger.LOG(14, 4, "p = " + this.portString);
            if (this.portString.equals("")) {
                this.portString = null;
                Logger.LOG(14, 4, "setting portstring to null");
            }
            if (this.portString != null) {
                try {
                    this.port = Integer.parseInt(this.portString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Port is not a number");
                }
                if (this.port < 1 || this.port > 65535) {
                    throw new IllegalArgumentException("Invalid Port number");
                }
            }
            this.endHost = this.startPort - 1;
        } else {
            this.endHost = this.authority.length();
        }
        Logger.LOG(14, 4, "startport = " + this.startPort);
        Logger.LOG(14, 4, "port = " + this.port);
        Logger.LOG(14, 4, "starthost = " + this.startHost + "endhost= " + this.endHost);
        if (this.endHost > this.startHost) {
            this.host = this.authority.substring(this.startHost, this.endHost);
        }
        Logger.LOG(14, 4, "host = " + this.host);
        if (this.host != null && this.host.startsWith("[") && this.host.endsWith("]")) {
            if (this.host.length() < 4) {
                throw new IllegalArgumentException("IPV6 adrress invalid");
            }
            if (this.host.startsWith("::")) {
                this.doubleColon = true;
            }
            if (this.endHost > this.startHost + 1) {
                this.checkIPv6format(this.host.substring(this.startHost + 1, this.endHost));
            }
        }
        if (this.isPath) {
            this.startPath = this.endAuthority;
            if (this.uri.indexOf(63, this.startPath) == -1) {
                this.isQuery = false;
                if (this.uri.indexOf(35, this.startPath) == -1) {
                    this.isFragment = false;
                    this.endPath = this.uri.length();
                } else {
                    this.endPath = this.uri.indexOf(35, this.startPath);
                }
            } else {
                this.endPath = this.uri.indexOf(63, this.startPath);
            }
        }
        if (this.endPath > this.startPath) {
            this.path = this.uri.substring(this.startPath, this.endPath);
        }
        if (this.isQuery) {
            this.startQuery = this.uri.indexOf(63, this.endAuthority);
            if (this.uri.indexOf(35, this.startQuery) == -1) {
                this.isFragment = false;
                this.endQuery = this.uri.length();
            } else {
                this.endQuery = this.uri.indexOf(35, this.startQuery);
            }
            if (this.endQuery > this.startQuery) {
                this.query = this.uri.substring(this.startQuery + 1, this.endQuery);
            }
        }
        if (this.isFragment) {
            this.startFragment = this.uri.indexOf(35, this.endAuthority);
            this.endFragment = this.uri.length();
            if (this.endFragment > this.startFragment) {
                this.fragment = this.uri.substring(this.startFragment + 1, this.endFragment);
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    private void checkIPv6format(String ipv6addr) {
        int start;
        int colon = 0;
        int doubleColon = 0;
        int end = 0;
        int index = 0;
        String fields = null;
        if (ipv6addr.startsWith("::") && ipv6addr.length() == 2) {
            return;
        }
        end = ipv6addr.length() - 1;
        for (start = 0; start <= end; ++start) {
            if (ipv6addr.indexOf("::", start) != -1) {
                ++doubleColon;
            }
            if (ipv6addr.indexOf(58, start) == -1) continue;
            ++colon;
        }
        if (doubleColon >= 2) {
            throw new IllegalArgumentException("Invalid IPV6 address");
        }
        if (doubleColon == 1 ? colon < 2 || colon > 6 : colon < 6 || colon > 7) {
            throw new IllegalArgumentException("invalid IPV6 address");
        }
        start = 0;
        while (start <= end && (index = ipv6addr.indexOf(58, start)) != -1) {
            if (index > start) {
                fields = ipv6addr.substring(start, index);
            }
            if (!this.validHex(fields) && !this.validIpv4(fields)) {
                throw new IllegalArgumentException("invalid IPv6 address");
            }
            start = index + 1;
        }
    }

    private boolean validHex(String fields) {
        byte hex = 0;
        if (fields.length() > 4) {
            return false;
        }
        byte[] hexarray = fields.getBytes();
        for (int i = 0; i < fields.length() - 1; ++i) {
            hex = hexarray[i];
            if (!(hex < 48 && hex > 57 || hex < 65 && hex > 70) && (hex >= 97 || hex <= 102)) continue;
            return false;
        }
        return true;
    }

    private boolean validIpv4(String fields) {
        int dot = 0;
        int start = 0;
        int end = 0;
        int len = fields.length();
        int index = 0;
        String dec = null;
        end = len - 1;
        if (len < 7 || len > 15) {
            return false;
        }
        while (start <= end && (index = fields.indexOf(46, start)) != -1) {
            int decval;
            ++dot;
            if (index > start) {
                dec = fields.substring(start, index);
            }
            if ((decval = Integer.parseInt(dec)) < 0 && decval > 255) {
                return false;
            }
            start = index + 1;
        }
        return dot == 3;
    }

    public String toString() {
        StringBuffer url = new StringBuffer();
        if (this.scheme != null) {
            url.append(this.scheme);
            url.append(':');
        }
        if (this.authority != null) {
            url.append('/');
            url.append('/');
            url.append(this.authority);
        }
        if (this.path != null) {
            url.append(this.path);
        }
        if (this.query != null) {
            url.append('?');
            url.append(this.query);
        }
        if (this.fragment != null) {
            url.append('#');
            url.append(this.fragment);
        }
        return url.toString();
    }
}

