/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.ApplicationInfo;
import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.LaunchAppInfo;
import com.nokia.mj.impl.installer.ui.eswt.ConfirmationViewBase;
import com.nokia.mj.impl.installer.ui.eswt.InstallerUiEswt;
import java.io.InputStream;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class LaunchAppQueryView
extends ConfirmationViewBase {
    private LaunchAppInfo iLaunchAppInfo = null;

    protected LaunchAppQueryView() {
    }

    protected LaunchAppQueryView(Composite aParent) {
        super(aParent, 4);
        this.setTitle(InstallerUiTexts.get("complete"));
        this.setCommands(InstallerUiTexts.get("start"), InstallerUiTexts.get("close"));
    }

    public boolean launchAppQuery(LaunchAppInfo aLaunchAppInfo) {
        if (this.isDisposed() || aLaunchAppInfo == null) {
            return false;
        }
        this.iLaunchAppInfo = aLaunchAppInfo;
        boolean result = this.confirm();
        return result;
    }

    protected void createView() {
        GridData gridData = null;
        int horizontalSpan = this.getColumns();
        int labelStyle = 64;
        String title = InstallerUiTexts.get("complete");
        Label titleLabel = this.createLabel(title, this.getColumns(), labelStyle);
        ApplicationInfo[] applications = this.iLaunchAppInfo.getApplications();
        if (applications != null) {
            InputStream suiteIconInputStream = this.iLaunchAppInfo.getSuiteIconInputStream();
            Image suiteIcon = null;
            if (suiteIconInputStream != null) {
                suiteIcon = InstallerUiEswt.loadImage(this.getComposite().getDisplay(), suiteIconInputStream, this.iLaunchAppInfo.getSuiteIconPath());
            }
            InputStream[] appIconInputStreams = this.iLaunchAppInfo.getAppIconInputStreams();
            Button[] appButtons = new Button[applications.length];
            for (int i = 0; i < applications.length; ++i) {
                Image appIcon = null;
                if (appIconInputStreams != null && appIconInputStreams.length > i && appIconInputStreams[i] != null) {
                    appIcon = InstallerUiEswt.loadImage(this.getComposite().getDisplay(), appIconInputStreams[i], applications[i].getIconPath());
                }
                if (appIcon == null && suiteIcon != null) {
                    appIcon = suiteIcon;
                }
                if (appIcon != null) {
                    Label iconLabel = this.createLabel(appIcon, 1, 0);
                    horizontalSpan = this.getColumns() - 1;
                } else {
                    horizontalSpan = this.getColumns();
                }
                appButtons[i] = new Button(this.getComposite(), 8);
                gridData = new GridData(768);
                gridData.horizontalSpan = horizontalSpan;
                appButtons[i].setLayoutData((Object)gridData);
                appButtons[i].setText(applications[i].getName());
                final int index = i;
                appButtons[i].addListener(13, new Listener(){

                    public void handleEvent(Event aEvent) {
                        LaunchAppQueryView.this.iLaunchAppInfo.setSelection(index);
                        LaunchAppQueryView.this.confirmOk();
                    }
                });
                appButtons[i].addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent aEvent) {
                        LaunchAppQueryView.this.getScrolledComposite().showControl((Control)aEvent.widget);
                        if (!LaunchAppQueryView.this.userHasAnswered()) {
                            LaunchAppQueryView.this.iLaunchAppInfo.setSelection(index);
                        }
                    }

                    public void focusLost(FocusEvent aEvent) {
                    }
                });
            }
        }
    }

    protected void getDataFromView() {
    }

    protected int getStyle() {
        return 512;
    }
}

