/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.location;

import com.nokia.mj.impl.location.LAPIManager;
import com.nokia.mj.impl.location.LandmarkStoreMap;
import com.nokia.mj.impl.location.Locator;
import com.nokia.mj.impl.location.NativeError;
import com.nokia.mj.impl.rt.support.Finalizer;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.location.LandmarkStore;

public class LandmarkStoreManager {
    private static LandmarkStoreManager sInstance;
    private final LandmarkStoreMap iStoreMap;
    private final int iManagerHandle;
    private final int iFunctionSourceHandle;
    private Finalizer mFinalizer = this.registerForFinalization();
    private static final String LANDMARKSTORE_OPERATION_ERROR = "Unable to do landmarkStore operation";
    private static final String LIST_LANDMARK_STORES_ERROR = "Unable to list landmarkStores: ";

    public static synchronized LandmarkStoreManager getInstance() {
        if (sInstance == null) {
            sInstance = new LandmarkStoreManager();
        }
        return sInstance;
    }

    private LandmarkStoreManager() {
        this.iFunctionSourceHandle = LAPIManager.getInstance().getFunctionSourceHandle();
        this.iManagerHandle = this._createNativePeer(this.iFunctionSourceHandle);
        if (this.iManagerHandle < 0) {
            throw new OutOfMemoryError(LANDMARKSTORE_OPERATION_ERROR);
        }
        this.iStoreMap = new LandmarkStoreMap();
    }

    Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                LandmarkStoreManager.this.doFinalize();
            }
        };
    }

    final void doFinalize() {
        this._dispose(this.iFunctionSourceHandle, this.iManagerHandle);
    }

    public LandmarkStore getStore(Locator aLocator) {
        String uri = aLocator != null ? aLocator.getStoreURI() : "";
        return this.iStoreMap.getStore(uri);
    }

    public void registerStore(LandmarkStore aStore, String aStoreUri) {
        this.iStoreMap.registerStore(aStore, aStoreUri);
    }

    public int openStore(Locator aLocator) {
        String uri = aLocator != null ? aLocator.getStoreURI() : null;
        int handle = this._openStore(this.iFunctionSourceHandle, this.iManagerHandle, uri);
        return handle;
    }

    public int createStore(Locator aLocator) {
        if (aLocator == null) {
            throw new NullPointerException();
        }
        String uri = aLocator.getStoreURI();
        return this._createStore(this.iFunctionSourceHandle, this.iManagerHandle, uri);
    }

    public int deleteStore(Locator aLocator) {
        if (aLocator == null) {
            throw new NullPointerException();
        }
        String uri = aLocator.getStoreURI();
        this.iStoreMap.unregisterStore(uri);
        return this._deleteStore(this.iFunctionSourceHandle, this.iManagerHandle, uri);
    }

    public void removeStore(String aStoreUri, int aStoreHandle) {
        if (aStoreUri != null) {
            this.iStoreMap.unregisterStore(aStoreUri);
        }
        this._removeStore(this.iFunctionSourceHandle, this.iManagerHandle, aStoreHandle);
    }

    public Vector listStores() throws IOException {
        int[] errors = new int[1];
        String[] storeUris = this._listStores(this.iFunctionSourceHandle, this.iManagerHandle, errors);
        NativeError.checkIO(errors[0], LIST_LANDMARK_STORES_ERROR);
        Vector locators = null;
        if (storeUris != null && storeUris.length > 0) {
            locators = new Vector(storeUris.length);
            for (int i = 0; i < storeUris.length; ++i) {
                try {
                    Locator locator = new Locator(storeUris[i]);
                    locators.addElement(locator);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        return locators;
    }

    private native int _createNativePeer(int var1);

    private native int _openStore(int var1, int var2, String var3);

    private native int _createStore(int var1, int var2, String var3);

    private native int _deleteStore(int var1, int var2, String var3);

    private native void _removeStore(int var1, int var2, int var3);

    private native String[] _listStores(int var1, int var2, int[] var3);

    private native void _dispose(int var1, int var2);
}

