/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.location;

import com.nokia.mj.impl.location.Blocker;
import com.nokia.mj.impl.location.LocationData;
import com.nokia.mj.impl.location.LocationPermission;
import com.nokia.mj.impl.location.NativeError;
import com.nokia.mj.impl.location.Positioner;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;
import javax.microedition.location.AddressInfo;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationListener;
import javax.microedition.location.LocationProvider;
import javax.microedition.location.QualifiedCoordinates;

public final class LocationProviderImpl
extends LocationProvider {
    private static final int ADDRESS_REQUIRED = 1;
    private static final int COST_ALLOWED = 2;
    private static final int ALTITUDE_REQUIRED = 4;
    private static final int SPEED_AND_COURSE_REQUIRED = 8;
    private static final int NUM_ADDRESS_FIELDS = 17;
    private final int iFunctionServerHandle;
    private Finalizer iFinalizer = this.registerFinalize();
    private final int iHandle;
    private int iTrackingPositionerHandle;
    private LocationListener iListener = null;
    private static final Blocker iLock;
    private volatile int iState = 1;
    private int iLocationMethod;
    private int iRequired = 0;
    private int iTimeout;
    private static final String LOCATION_REQUEST_ERROR_STRING = "Location request timed out";
    private static final String ALL_POSITIONING_METHODS_DISABLED = "All positioning methods are disabled";
    private static final String OBTAIN_LOCATION_INTERRUPTED_ERROR = "Obtaining location was interrupted";
    private static final String INVALID_LOCATION_LISTENER_ARGUMENT_ERROR = "Invalid arguments for interval, timeout or maxAge: ";
    private static final String INVALID_TIMEOUT_ARGUMENT_ERROR = "Timeout value is invalid";
    private static final String OBTAIN_LOCATION_PROVIDER_ERROR = "Unable to obtain location provider: ";
    private static final String SET_LOCATION_LISTENER_ERROR = "Unable to set location listener:";

    public LocationProviderImpl() {
        this.iFunctionServerHandle = this._createFunctionSource();
        this.iHandle = this._createProvider(this.iFunctionServerHandle);
    }

    public boolean selectModule(Criteria aCr) throws LocationException {
        int hAcc = 0;
        int vAcc = 0;
        int respTime = 0;
        int power = 0;
        int required = 2;
        if (aCr != null) {
            hAcc = aCr.getHorizontalAccuracy();
            vAcc = aCr.getVerticalAccuracy();
            respTime = aCr.getPreferredResponseTime();
            power = aCr.getPreferredPowerConsumption();
            if (aCr.isAddressInfoRequired()) {
                required |= 1;
            }
            if (!aCr.isAllowedToCost()) {
                required ^= 2;
            }
            if (aCr.isAltitudeRequired()) {
                required |= 4;
            }
            if (aCr.isSpeedAndCourseRequired()) {
                required |= 8;
            }
        }
        this.iRequired = required;
        int[] retArgs = new int[2];
        int ret = this._selectModule(this.iFunctionServerHandle, this.iHandle, hAcc, vAcc, respTime, power, required, retArgs);
        if (ret < 0) {
            if (ret == -1) {
                throw new LocationException(ALL_POSITIONING_METHODS_DISABLED);
            }
            if (ret == -5) {
                return false;
            }
            NativeError.check(ret, OBTAIN_LOCATION_PROVIDER_ERROR);
        }
        this.iTrackingPositionerHandle = ret;
        this.iLocationMethod = retArgs[0];
        int timeout = retArgs[1];
        this.iTimeout = Math.max(timeout, 15);
        return true;
    }

    public int getState() {
        return this.iState;
    }

    public void reset() {
        Positioner.resetAll();
    }

    public Location getLocation(int aTimeout) throws LocationException, InterruptedException {
        Positioner pos;
        block4: {
            int timeout;
            ApplicationUtils appUtils = ApplicationUtils.getInstance();
            LocationPermission permission = new LocationPermission("location://*", "position");
            appUtils.checkPermission(permission);
            if (aTimeout <= 0 && aTimeout != -1) {
                throw new IllegalArgumentException(INVALID_TIMEOUT_ARGUMENT_ERROR);
            }
            pos = Positioner.getPositioner(this);
            int currentTimeout = timeout = aTimeout == -1 ? this.iTimeout : aTimeout;
            long startTime = System.currentTimeMillis();
            while (this.iState != 3) {
                int ret = pos.getLocation(currentTimeout);
                if (ret != 0) {
                    if (pos.iCancelled) {
                        throw new InterruptedException(OBTAIN_LOCATION_INTERRUPTED_ERROR);
                    }
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    currentTimeout = timeout - (int)(elapsedTime / 1000L);
                    if (currentTimeout > 0) continue;
                }
                break block4;
            }
            pos.release();
            throw new LocationException(LOCATION_REQUEST_ERROR_STRING);
        }
        LocationData loc = new LocationData(this.iLocationMethod);
        this.setLocationData(loc, pos.iPositionerHandle);
        pos.release();
        return loc;
    }

    public void setLocationListener(LocationListener aListener, int aInterval, int aTimeout, int aMaxAge) {
        if (aListener == null || aInterval == 0) {
            if (this.iListener != null) {
                this._stopTracking(this.iFunctionServerHandle, this.iHandle);
            }
            this.iListener = aListener;
        } else {
            if (aInterval < -1 || aInterval > 0 && (aTimeout > aInterval || aMaxAge > aInterval || aTimeout < 1 && aTimeout != -1 || aMaxAge < 1 && aMaxAge != -1)) {
                throw new IllegalArgumentException(INVALID_LOCATION_LISTENER_ARGUMENT_ERROR + aInterval + ", " + aTimeout + "or " + aMaxAge);
            }
            ApplicationUtils appUtils = ApplicationUtils.getInstance();
            LocationPermission permission = new LocationPermission("location://*", "position");
            appUtils.checkPermission(permission);
            if (this.iListener != null) {
                this._stopTracking(this.iFunctionServerHandle, this.iHandle);
            }
            this.iListener = aListener;
            int err = this._startTracking(this.iFunctionServerHandle, this.iHandle, aInterval, aTimeout, aMaxAge);
            NativeError.check(err, SET_LOCATION_LISTENER_ERROR);
        }
    }

    public static Location getLastKnownLocation() {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("location://*", "position");
        appUtils.checkPermission(permission);
        double[] latlong = new double[2];
        float[] altHaccVacc = new float[3];
        long[] timestamp = new long[1];
        int ret = LocationProviderImpl._getLastKnownLocation(latlong, altHaccVacc, timestamp);
        if (ret == 0) {
            LocationData loc = new LocationData(0);
            QualifiedCoordinates qc = new QualifiedCoordinates(latlong[0], latlong[1], altHaccVacc[0], altHaccVacc[1], altHaccVacc[2]);
            loc.setLocationData(qc, timestamp[0], null);
            return loc;
        }
        return null;
    }

    private Finalizer registerFinalize() {
        return new Finalizer(){

            public void finalizeImpl() {
                LocationProviderImpl.this.registeredFinalize();
            }
        };
    }

    void complete(int aError) {
        if (this.iListener == null) {
            return;
        }
        LocationData loc = new LocationData(this.iLocationMethod);
        if (aError == 0) {
            this.setLocationData(loc, this.iTrackingPositionerHandle);
        }
        this.iListener.locationUpdated(this, loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncComplete(int aError) {
        Blocker blocker = iLock;
        synchronized (blocker) {
            iLock.setresult(aError);
            iLock.notify();
        }
    }

    void stateChange(int aNewState) {
        this.iState = aNewState;
        if (this.iListener == null) {
            return;
        }
        this.iListener.providerStateChanged(this, aNewState);
    }

    private void setLocationData(LocationData aLocation, int aPositionerHandle) {
        float[] speedCourse;
        boolean hasSpeedAndCourse;
        String[] addr;
        int availableFields;
        if ((this.iRequired & 1) != 0 && (availableFields = this._getAddressInfo(aPositionerHandle, addr = new String[17])) > 0) {
            AddressInfo addrInfo = new AddressInfo();
            for (int i = 0; i < 17; ++i) {
                if ((availableFields & 1 << i) <= 0) continue;
                addrInfo.setField(i + 1, addr[i]);
            }
            aLocation.setAddressInfo(addrInfo);
        }
        if ((this.iRequired & 8) != 0 && (hasSpeedAndCourse = this._getSpeedAndCourse(aPositionerHandle, speedCourse = new float[2]))) {
            aLocation.setSpeedAndCourse(speedCourse[0], speedCourse[1]);
        }
        double[] latlong = new double[2];
        float[] altHaccVacc = new float[3];
        String[] nmeaData = new String[1];
        long timestamp = this._getQualifiedCoordinates(aPositionerHandle, latlong, altHaccVacc, nmeaData);
        QualifiedCoordinates qc = new QualifiedCoordinates(latlong[0], latlong[1], altHaccVacc[0], altHaccVacc[1], altHaccVacc[2]);
        aLocation.setLocationData(qc, timestamp, nmeaData[0]);
    }

    void registeredFinalize() {
        this._dispose(this.iFunctionServerHandle, this.iHandle);
    }

    int getProviderHandle() {
        return this.iHandle;
    }

    int getFunctionSourceHandle() {
        return this.iFunctionServerHandle;
    }

    private native void _dispose(int var1, int var2);

    private native int _createProvider(int var1);

    private native int _createFunctionSource();

    private native int _selectModule(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int[] var8);

    private native long _getQualifiedCoordinates(int var1, double[] var2, float[] var3, String[] var4);

    private native boolean _getSpeedAndCourse(int var1, float[] var2);

    private native int _startTracking(int var1, int var2, int var3, int var4, int var5);

    private native void _stopTracking(int var1, int var2);

    private native int _getAddressInfo(int var1, String[] var2);

    private static native int _getLastKnownLocation(double[] var0, float[] var1, long[] var2);

    static {
        try {
            Jvm.loadSystemLibrary("javalocation");
        }
        catch (Exception e) {
            Logger.ELOG(24, "Unable to load javalocation dll.");
        }
        try {
            Jvm.loadSystemLibrary("lbt.dll");
        }
        catch (Exception e) {
            Logger.ELOG(24, "Unable to load lbt dll.");
        }
        iLock = new Blocker();
    }
}

