/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.location;

public class Locator {
    public static final String DB_FILE_EXTENSION = ".ldb";
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String DB_DEFAULT_PROTOCOL = "file";
    private String iLocatorString;
    private static final String DEFAULT_DRIVE = "c:";
    private static final int MIN_SPECIAL_NAME_LENGTH = 5;

    public static Locator createLocator(String aName) {
        StringBuffer buffer = new StringBuffer(DB_DEFAULT_PROTOCOL);
        buffer.append(PROTOCOL_SEPARATOR);
        int length = aName.length();
        int driveStart = aName.lastIndexOf(40);
        int driveEnd = aName.indexOf(":)");
        if (length >= 5 && aName.endsWith(":)") && driveEnd == driveStart + DEFAULT_DRIVE.length()) {
            buffer.append(aName.substring(driveStart + 1, driveEnd + 1));
            buffer.append(aName.substring(0, driveStart - 1));
        } else {
            buffer.append(DEFAULT_DRIVE);
            buffer.append(aName);
        }
        buffer.append(DB_FILE_EXTENSION);
        return new Locator(buffer.toString());
    }

    Locator(String aLocatorString) {
        if (aLocatorString.indexOf(PROTOCOL_SEPARATOR) == -1) {
            throw new IllegalArgumentException();
        }
        this.iLocatorString = aLocatorString;
    }

    public String getStoreURI() {
        return this.iLocatorString;
    }

    public String getName() {
        int s = this.getProtocol().length() + PROTOCOL_SEPARATOR.length();
        int e = this.getExtension().length();
        String drive = this.getDrive().toLowerCase();
        StringBuffer buffer = new StringBuffer(this.iLocatorString.substring(s + drive.length(), this.iLocatorString.length() - e));
        if (drive.length() > 0 && !drive.equals(DEFAULT_DRIVE)) {
            buffer.append(" (");
            buffer.append(drive);
            buffer.append(")");
        }
        return buffer.toString();
    }

    private String getDrive() {
        int colon = this.iLocatorString.lastIndexOf(58);
        return colon != -1 ? this.iLocatorString.substring(colon - 1, colon + 1) : "";
    }

    private String getExtension() {
        int sep = this.iLocatorString.indexOf(DB_FILE_EXTENSION);
        if (sep == -1) {
            sep = this.iLocatorString.lastIndexOf(46);
        }
        return sep != -1 ? this.iLocatorString.substring(sep, this.iLocatorString.length()) : "";
    }

    private String getProtocol() {
        int sep = this.iLocatorString.indexOf(PROTOCOL_SEPARATOR);
        return sep != -1 ? this.iLocatorString.substring(0, sep) : "";
    }
}

