/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.location;

import java.io.IOException;

public final class NativeError {
    public static final String NATIVE_ERROR_MESSAGE = "OS error = ";
    public static final int KErrNone = 0;
    public static final int KErrNotFound = -1;
    public static final int KErrGeneral = -2;
    public static final int KErrCancel = -3;
    public static final int KErrNoMemory = -4;
    public static final int KErrNotSupported = -5;
    public static final int KErrArgument = -6;
    public static final int KErrOverflow = -9;
    public static final int KErrAlreadyExists = -11;
    public static final int KErrPathNotFound = -12;
    public static final int KErrDied = -13;
    public static final int KErrNotReady = -18;
    public static final int KErrCorrupt = -20;
    public static final int KErrAccessDenied = -21;
    public static final int KErrWrite = -23;
    public static final int KErrEof = -25;
    public static final int KErrDiskFull = -26;
    public static final int KErrBadName = -28;
    public static final int KErrCommsLineFail = -29;
    public static final int KErrTimedOut = -33;
    public static final int KErrDisconnected = -36;
    public static final int KErrTooBig = -40;
    public static final int KErrDivideByZero = -41;
    public static final int KErrHardwareNotAvailable = -44;

    private NativeError() {
    }

    public static int checkIO(int aError, String aErrorMessage) throws IOException {
        if (aError < 0) {
            switch (aError) {
                case -4: {
                    throw new OutOfMemoryError(aErrorMessage + Integer.toString(aError));
                }
                case -6: {
                    throw new IllegalArgumentException(aErrorMessage + Integer.toString(aError));
                }
                case -41: {
                    throw new ArithmeticException(aErrorMessage + Integer.toString(aError));
                }
            }
            throw new IOException(aErrorMessage + NativeError.errorMessage(aError));
        }
        return aError;
    }

    public static int check(int aError, String aErrorMessage) {
        if (aError < 0) {
            NativeError.checkExplicitOnly(aError, aErrorMessage);
            throw new Error(aErrorMessage + NativeError.errorMessage(aError));
        }
        return aError;
    }

    public static int checkExplicitOnly(int aError, String aErrorMessage) {
        if (aError < 0) {
            switch (aError) {
                case -4: {
                    throw new OutOfMemoryError(aErrorMessage + Integer.toString(aError));
                }
                case -6: {
                    throw new IllegalArgumentException(aErrorMessage + Integer.toString(aError));
                }
                case -41: {
                    throw new ArithmeticException(aErrorMessage + Integer.toString(aError));
                }
            }
        }
        return aError;
    }

    public static String errorMessage(int aError) {
        String result = NATIVE_ERROR_MESSAGE.concat(Integer.toString(aError));
        return result;
    }
}

