/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.mms;

import com.nokia.mj.impl.mms.MessagePartFactory;
import com.nokia.mj.impl.mms.MmsPropertyRetriever;
import com.nokia.mj.impl.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.SizeExceededException;

public final class MessagePartImpl {
    private String iMimeType = null;
    private String iContentId = null;
    private String iContentLocation = null;
    private String iContentEncoding = null;
    private byte[] iContent = null;
    private static MessagePartFactory iMessagePartFactory = null;
    private static final int MAX_CONTENT_LOCATION_LENGTH = 256;
    private static final int MAX_ATTCH_HEADERS_LENGTH = 10000;

    public static void registerFactory(MessagePartFactory aMessagePartFactory) {
        if (aMessagePartFactory != null && iMessagePartFactory == null) {
            iMessagePartFactory = aMessagePartFactory;
        }
    }

    public MessagePartImpl() {
        Logger.LOG(15, 4, "+ MessagePartImpl::MessagePartImpl()");
        if (iMessagePartFactory == null) {
            try {
                Class.forName("javax.wireless.messaging.MessagePart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Logger.LOG(15, 4, "- MessagePartImpl::MessagePartImpl()");
    }

    public MessagePartImpl(InputStream aInputStream, String aMimeType, String aContentId, String aContentLocation, String aEncoding) throws IOException, SizeExceededException {
        Logger.LOG(15, 4, "+ MessagePartImpl::MessagePartImpl()");
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        if (aInputStream != null) {
            byte[] buf = new byte[1024];
            int length = aInputStream.read(buf, 0, 1024);
            while (length != -1) {
                oStream.write(buf, 0, length);
                length = aInputStream.read(buf, 0, 1024);
            }
        }
        byte[] contents = oStream.toByteArray();
        oStream.close();
        this.initMessagePart(contents, 0, contents.length, aMimeType, aContentId, aContentLocation, aEncoding);
        Logger.LOG(15, 4, "- MessagePartImpl::MessagePartImpl()");
    }

    public MessagePartImpl(byte[] aContents, String aMimeType, String aContentId, String aContentLocation, String aEncoding) throws SizeExceededException {
        Logger.LOG(15, 4, "+ MessagePartImpl::MessagePartImpl()");
        this.initMessagePart(aContents, 0, aContents == null ? 0 : aContents.length, aMimeType, aContentId, aContentLocation, aEncoding);
        Logger.LOG(15, 4, "- MessagePartImpl::MessagePartImpl()");
    }

    public MessagePartImpl(byte[] aContents, int aOffset, int aLength, String aMimeType, String aContentId, String aContentLocation, String aEncoding) throws SizeExceededException {
        this.initMessagePart(aContents, aOffset, aLength, aMimeType, aContentId, aContentLocation, aEncoding);
    }

    public byte[] getContent() {
        return this.iContent;
    }

    public InputStream getContentAsStream() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.iContent);
        return inputStream;
    }

    public String getContentID() {
        return this.iContentId;
    }

    public String getMIMEType() {
        return this.iMimeType;
    }

    public String getEncoding() {
        return this.iContentEncoding;
    }

    public String getContentLocation() {
        return this.iContentLocation;
    }

    public int getLength() {
        return this.iContent != null ? this.iContent.length : 0;
    }

    public boolean equals(Object aObj) {
        Logger.LOG(15, 4, "+ MessagePartImpl::equals()");
        if (aObj instanceof String) {
            String ID = (String)aObj;
            String ownID = this.getContentID();
            if (ownID != null && ownID.equals(ID)) {
                return true;
            }
        } else if (aObj instanceof MessagePart) {
            MessagePart otherPart = (MessagePart)aObj;
            return this.equals(otherPart.getContentID());
        }
        Logger.LOG(15, 4, "- MessagePartImpl::equals()");
        return false;
    }

    public String toString() {
        return "MimeType: " + this.iMimeType + "\nContentID: " + this.iContentId + "\nContentLocation: " + this.iContentLocation + "\nContentEncoding: " + this.iContentEncoding + "\nContent: " + this.iContent;
    }

    public void initMessagePart(byte[] aContents, String aMimeType, String aContentId, String aContentLocation, String aEncoding) {
        Logger.LOG(15, 4, "+ MessagePartImpl::initMessagePart()");
        this.iMimeType = aMimeType;
        this.iContentId = aContentId;
        this.iContentLocation = aContentLocation;
        this.iContentEncoding = aEncoding;
        if (aContents == null) {
            this.iContent = null;
        } else {
            this.iContent = new byte[aContents.length];
            System.arraycopy((Object)aContents, 0, (Object)this.iContent, 0, aContents.length);
        }
        Logger.LOG(15, 4, "- MessagePartImpl::initMessagePart()");
    }

    static MessagePartImpl getInstance(String aContentId) {
        return new MessagePartImpl(aContentId);
    }

    static MessagePart initializeMessagePart(byte[] aContents, String aMimeType, String aContentId, String aContentLocation, String aEncoding) {
        return iMessagePartFactory.initializeMessagePart(aContents, aMimeType, aContentId, aContentLocation, aEncoding);
    }

    private MessagePartImpl(String aContentId) {
        this.iContentId = aContentId;
    }

    private void isASCII(String aStr) {
        for (int i = 0; i < aStr.length(); ++i) {
            char c = aStr.charAt(i);
            if ((c & 0xFF) <= 127) continue;
            throw new IllegalArgumentException("String contains non US-ASCII characters" + aStr);
        }
    }

    private void initMessagePart(byte[] aContents, int aOffset, int aLength, String aMimeType, String aContentId, String aContentLocation, String aEncoding) throws SizeExceededException {
        Logger.LOG(15, 4, "+ MessagePartImpl::initMessagePart()");
        boolean nullContent = false;
        if (aContents == null) {
            nullContent = true;
            aContents = new byte[]{};
        }
        if (aLength < 0 || aOffset < 0 || aOffset + aLength > aContents.length) {
            throw new IllegalArgumentException("Length " + aLength + " or offset " + aOffset + " is < 0, or their sum" + " exceeds the content array length");
        }
        if (aContents.length > MmsPropertyRetriever.getMMSMaxSize()) {
            throw new SizeExceededException("MessagePart size exceeds the maximum supported size");
        }
        if (aMimeType == null) {
            throw new IllegalArgumentException("MIME type is null");
        }
        if (aContentId == null) {
            throw new IllegalArgumentException("Content-id is null");
        }
        this.isASCII(aContentId);
        int attchHeadersLength = aMimeType.length() + aContentId.length();
        if (aContentLocation != null && aContentLocation.length() > 0) {
            this.isASCII(aContentLocation);
            if (aContentLocation.length() > 256) {
                throw new SizeExceededException("Content location length exceeds the maximum supported size ");
            }
            attchHeadersLength += aContentLocation.length();
        }
        if (attchHeadersLength >= 10000) {
            throw new SizeExceededException("Total size of MIME type,content-id and content location exceeds the max supported size");
        }
        if (aEncoding != null && aEncoding.length() > 0 && !MmsPropertyRetriever.isValidEncoding(aEncoding)) {
            throw new IllegalArgumentException("Unsupported encoding: " + aEncoding);
        }
        this.iMimeType = aMimeType;
        this.iContentId = aContentId;
        this.iContentLocation = aContentLocation;
        this.iContentEncoding = aEncoding;
        if (nullContent) {
            this.iContent = null;
        } else {
            this.iContent = new byte[aLength];
            System.arraycopy((Object)aContents, aOffset, (Object)this.iContent, 0, aLength);
        }
        Logger.LOG(15, 4, "- MessagePartImpl::initMessagePart()");
    }
}

