/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.pim;

import com.nokia.mj.impl.pim.EventImpl;
import com.nokia.mj.impl.pim.GenericException;
import com.nokia.mj.impl.pim.PIMItemImpl;
import com.nokia.mj.impl.pim.PIMListImpl;
import com.nokia.mj.impl.pim.RepeatRuleInvoker;
import com.nokia.mj.impl.pim.utils.NativeError;
import java.util.Enumeration;
import javax.microedition.pim.Event;
import javax.microedition.pim.EventList;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.RepeatRule;

public final class EventListImpl
extends PIMListImpl
implements EventList {
    EventListImpl(int aListHandle, int aMode) {
        super(aListHandle, aMode);
    }

    int getListType() {
        return 2;
    }

    protected PIMItemImpl createAssociatedItem(int aItemHandle) {
        int[] err = new int[1];
        int repeatRuleHandle = this._createRepeatRuleHandle(aItemHandle, err);
        if (!NativeError.checkSuccess(err[0])) {
            throw new GenericException("General error:" + err[0]);
        }
        RepeatRule repeatRule = RepeatRuleInvoker.createRepeatRule(repeatRuleHandle);
        return new EventImpl(aItemHandle, repeatRule, this);
    }

    public synchronized Event createEvent() {
        return (EventImpl)this.createItem();
    }

    public synchronized Event importEvent(Event aEvent) {
        if (aEvent == null) {
            throw new NullPointerException("Importing failed:Import item is null");
        }
        EventImpl eventItem = (EventImpl)this.createItem();
        eventItem.copyFrom(aEvent);
        this.updateRevisionField(eventItem, 105, 0);
        return eventItem;
    }

    public synchronized void removeEvent(Event aEvent) throws PIMException {
        this.checkModeMinimum(2);
        this.removeItem(aEvent);
    }

    public synchronized Enumeration items(int aSearchType, long aStartDate, long aEndDate, boolean aInitialEventOnly) throws PIMException {
        this.ensurePimPermission(1);
        if (aSearchType != 0 && aSearchType != 1 && aSearchType != 2) {
            throw new IllegalArgumentException("Searching failed:Invalid search type: " + aSearchType);
        }
        if (aStartDate > aEndDate) {
            throw new IllegalArgumentException("Searching failed:Start date is after end date");
        }
        this.updateList(0);
        int[] error = new int[1];
        int[] itemHandles = this._itemsByDate(this.iListHandle, aSearchType, aStartDate, aEndDate, aInitialEventOnly, error);
        return this.processItemsResults(itemHandles, error[0]);
    }

    public synchronized int[] getSupportedRepeatRuleFields(int aFrequency) {
        if (aFrequency != 16 && aFrequency != 17 && aFrequency != 18 && aFrequency != 19) {
            throw new IllegalArgumentException("Invalid frequency: " + aFrequency);
        }
        int[] err = new int[1];
        int[] supportedRepeatRuleFields = this._getSupportedRepeatRuleFields(this.iListHandle, aFrequency, err);
        NativeError.handleRepeatRuleFieldsError(err[0], aFrequency);
        if (supportedRepeatRuleFields == null) {
            throw new OutOfMemoryError();
        }
        return supportedRepeatRuleFields;
    }

    private native int[] _itemsByDate(int var1, int var2, long var3, long var5, boolean var7, int[] var8);

    private native int[] _getSupportedRepeatRuleFields(int var1, int var2, int[] var3);

    private native int _createRepeatRuleHandle(int var1, int[] var2);
}

