/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.pim;

import com.nokia.mj.impl.pim.ContactListImpl;
import com.nokia.mj.impl.pim.EventListImpl;
import com.nokia.mj.impl.pim.GenericException;
import com.nokia.mj.impl.pim.PIMListImpl;
import com.nokia.mj.impl.pim.PIMPermissionImpl;
import com.nokia.mj.impl.pim.Serializer;
import com.nokia.mj.impl.pim.ToDoListImpl;
import com.nokia.mj.impl.pim.utils.NativeError;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;

public final class PIMManager
extends PIM {
    private static PIMManager sInstance = null;
    private Finalizer iFinalizer;
    private int iManagerHandle;
    private Serializer iSerializer;

    public static synchronized PIM getInstance() {
        if (sInstance == null) {
            sInstance = new PIMManager();
        }
        return sInstance;
    }

    private PIMManager() {
        this.setShutdownListener();
        this.iFinalizer = this.registerForFinalization();
        int[] error = new int[1];
        this.iManagerHandle = this._createPIMManager(error);
        if (!NativeError.checkSuccess(error[0])) {
            throw new GenericException("General error:" + error[0]);
        }
        this.iSerializer = new Serializer(this.iManagerHandle);
    }

    public Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                PIMManager.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        if (this.iManagerHandle != 0) {
            this._dispose(this.iManagerHandle);
            this.iManagerHandle = 0;
        }
    }

    private void setShutdownListener() {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                if (PIMManager.this.iManagerHandle != 0) {
                    PIMManager.this._dispose(PIMManager.this.iManagerHandle);
                    PIMManager.this.iManagerHandle = 0;
                }
            }
        });
    }

    int managerHandle() {
        return this.iManagerHandle;
    }

    public synchronized PIMList openPIMList(int aPimListType, int aMode) throws PIMException {
        return this.doOpenPIMList(aPimListType, aMode, null);
    }

    public synchronized PIMList openPIMList(int aPimListType, int aMode, String aName) throws PIMException {
        if (aName == null) {
            throw new NullPointerException("Opening lists failed:List name is null");
        }
        return this.doOpenPIMList(aPimListType, aMode, aName);
    }

    public synchronized String[] listPIMLists(int aPimListType) {
        if (aPimListType != 1 && aPimListType != 2 && aPimListType != 3) {
            throw new IllegalArgumentException("Listing available lists failed.Invalid list type: " + aPimListType);
        }
        this.getPermission(aPimListType, 1);
        int[] error = new int[1];
        String[] lists = this._listPIMLists(this.iManagerHandle, aPimListType, error);
        NativeError.handleListPIMListError(error[0]);
        return lists;
    }

    public synchronized PIMItem[] fromSerialFormat(InputStream aIs, String aEnc) throws PIMException, UnsupportedEncodingException {
        return this.iSerializer.fromSerialFormat(aIs, aEnc);
    }

    public synchronized void toSerialFormat(PIMItem aItem, OutputStream aOs, String aEnc, String aDataFormat) throws PIMException, UnsupportedEncodingException {
        this.iSerializer.toSerialFormat(aItem, aOs, aEnc, aDataFormat);
    }

    public synchronized String[] supportedSerialFormats(int aPimListType) {
        return this.iSerializer.supportedSerialFormats(aPimListType);
    }

    public void getPermission(int aListType, int aMode) {
        if (aMode != 1 && aMode != 2) {
            throw new IllegalArgumentException();
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        String action = null;
        if (aMode == 2) {
            switch (aListType) {
                case 1: {
                    action = "write_contacts";
                    break;
                }
                case 2: {
                    action = "write_events";
                    break;
                }
                case 3: {
                    action = "write_todos";
                }
            }
        } else {
            switch (aListType) {
                case 1: {
                    action = "read_contacts";
                    break;
                }
                case 2: {
                    action = "read_events";
                    break;
                }
                case 3: {
                    action = "read_todos";
                }
            }
        }
        PIMPermissionImpl per = new PIMPermissionImpl("pim://*", action);
        appUtils.checkPermission(per);
    }

    private PIMList doOpenPIMList(int aPimListType, int aMode, String aName) throws PIMException {
        if (aPimListType != 1 && aPimListType != 2 && aPimListType != 3) {
            throw new IllegalArgumentException("Invalid list type: " + aPimListType);
        }
        if (aMode != 1 && aMode != 2 && aMode != 3) {
            throw new IllegalArgumentException("Invalid mode: " + aMode);
        }
        if (aMode == 3) {
            this.getPermission(aPimListType, 1);
            this.getPermission(aPimListType, 2);
        } else {
            this.getPermission(aPimListType, aMode);
        }
        int[] error = new int[1];
        int listHandle = this._openPIMList(this.iManagerHandle, aPimListType, aName, error);
        NativeError.handleOpenPIMListError(error[0], aPimListType, aName);
        PIMListImpl pimList = null;
        switch (aPimListType) {
            case 1: {
                pimList = new ContactListImpl(listHandle, aMode);
                break;
            }
            case 2: {
                pimList = new EventListImpl(listHandle, aMode);
                break;
            }
            case 3: {
                pimList = new ToDoListImpl(listHandle, aMode);
                break;
            }
            default: {
                throw new PIMException("General error", 1);
            }
        }
        return pimList;
    }

    private native int _createPIMManager(int[] var1);

    private native void _dispose(int var1);

    private native int _openPIMList(int var1, int var2, String var3, int[] var4);

    private native String[] _listPIMLists(int var1, int var2, int[] var3);
}

