/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.push;

import com.nokia.mj.impl.gcf.PushSecurityUtils;
import com.nokia.mj.impl.installer.pushregistrator.PushInfo;
import com.nokia.mj.impl.push.PushDbHandler;
import com.nokia.mj.impl.push.PushMidletData;
import com.nokia.mj.impl.push.PushValidatorLoader;
import com.nokia.mj.impl.push.UidAndIsClassNameOfThisMidletInfo;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.storage.StorageFactory;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;
import javax.microedition.io.ConnectionNotFoundException;

public final class PushRegistryImpl {
    private static PushMidletData[] mMidletsInSuiteInfo = null;

    private PushRegistryImpl() {
    }

    public static synchronized String getFilter(String aURI) {
        Logger.LOG(8, 4, "PushRegistryImpl.getFilter()");
        if (null == aURI) {
            return null;
        }
        if (0 == (aURI = aURI.trim()).compareTo("")) {
            return null;
        }
        Uid suiteUid = ApplicationInfo.getInstance().getSuiteUid();
        return PushRegistryImpl.getFilter0(aURI, suiteUid.toString());
    }

    public static synchronized String getMIDlet(String aURI) {
        Logger.LOG(8, 4, "PushRegistryImpl.getMIDlet()");
        if (null == aURI) {
            return null;
        }
        if (0 == (aURI = aURI.trim()).compareTo("")) {
            return null;
        }
        Uid suiteUid = ApplicationInfo.getInstance().getSuiteUid();
        return PushRegistryImpl.getMIDlet0(aURI, suiteUid.toString());
    }

    public static synchronized String[] listConnections(boolean aAvailable) {
        Logger.LOG(8, 4, "PushRegistryImpl.listConnections()");
        Uid appUid = ApplicationInfo.getInstance().getSuiteUid();
        String[] retConns = PushRegistryImpl.listConnections0(aAvailable, appUid.toString());
        if (null == retConns) {
            return new String[0];
        }
        return retConns;
    }

    public static synchronized long registerAlarm(String aMIDletClassName, long aTime) throws ClassNotFoundException, ConnectionNotFoundException {
        Logger.LOG(8, 4, "PushRegistryImpl.registerAlarm()");
        if (null == aMIDletClassName) {
            throw new ClassNotFoundException("'midlet' argument is null");
        }
        if (0 == (aMIDletClassName = aMIDletClassName.trim()).compareTo("")) {
            throw new ClassNotFoundException("'midlet' argument is empty");
        }
        if (0L >= aTime) {
            throw new IllegalArgumentException("alarm time must be greater than zero");
        }
        PushSecurityUtils.ensurePermission("dynamicregistration", null);
        Uid suiteUid = ApplicationInfo.getInstance().getSuiteUid();
        String classNameOfThisMidlet = ApplicationInfo.getInstance().getMainClass();
        boolean isClassNameOfThisMidlet = false;
        if (0 == aMIDletClassName.compareTo(classNameOfThisMidlet)) {
            isClassNameOfThisMidlet = true;
        }
        return PushRegistryImpl.registerAlarm0(aTime, suiteUid.toString(), aMIDletClassName, isClassNameOfThisMidlet);
    }

    public static synchronized void registerConnection(String aConnection, String aMIDletClassName, String aFilter) throws ClassNotFoundException, IOException {
        Logger.LOG(8, 4, "PushRegistryImpl.registerConnection()");
        if (null == aConnection) {
            throw new IllegalArgumentException("'connection' argument is null");
        }
        if (null == aFilter) {
            throw new IllegalArgumentException("'filter' argument is null");
        }
        if (null == aMIDletClassName) {
            throw new ClassNotFoundException("'midlet' argument is null");
        }
        aConnection = aConnection.trim();
        aFilter = aFilter.trim();
        aMIDletClassName = aMIDletClassName.trim();
        if (0 == aConnection.compareTo("")) {
            throw new IllegalArgumentException("'connection' argument is empty");
        }
        if (0 == aFilter.compareTo("")) {
            throw new IllegalArgumentException("'filter' argument is empty");
        }
        if (0 == aMIDletClassName.compareTo("")) {
            throw new ClassNotFoundException("'midlet' argument is empty");
        }
        String nameOfThisMidlet = ApplicationInfo.getInstance().getName();
        Uid suiteUid = ApplicationInfo.getInstance().getSuiteUid();
        PushValidatorLoader.getInstance().validatePushArguments(aConnection, aFilter, suiteUid, nameOfThisMidlet, false);
        PushMidletData tmpObj = PushRegistryImpl.isValidClassName(aMIDletClassName);
        PushSecurityUtils.ensurePermission("dynamicregistration", null);
        PushRegistryImpl.registerConnection0(aConnection, aMIDletClassName, aFilter, tmpObj.mUid.toString(), tmpObj.mIsClassNameOfThisMidlet);
    }

    public static synchronized boolean unregisterConnection(String aConnection) {
        Logger.LOG(8, 4, "PushRegistryImpl.unregisterConnection()");
        if (null == aConnection) {
            return false;
        }
        if (0 == (aConnection = aConnection.trim()).compareTo("")) {
            return false;
        }
        UidAndIsClassNameOfThisMidletInfo tmpObj = null;
        try {
            tmpObj = PushRegistryImpl.isValidConnToUnReg(aConnection);
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Logger.LOG(8, 1, "ERROR!!! unregisterConnection(): " + ex.toString());
            return false;
        }
        return PushRegistryImpl.unregisterConnection0(aConnection, tmpObj.mUid.toString(), tmpObj.mIsClassNameOfThisMidlet);
    }

    static PushMidletData isValidClassName(String aMIDletClassName) throws IOException, ClassNotFoundException {
        Logger.LOG(8, 4, "PushRegistryImpl.isValidClassName()");
        String classNameOfThisMidlet = ApplicationInfo.getInstance().getMainClass();
        boolean isClassNameOfThisMidlet = true;
        Uid uidOfMidlet = null;
        String midletName = null;
        if (0 == aMIDletClassName.compareTo(classNameOfThisMidlet)) {
            uidOfMidlet = ApplicationInfo.getInstance().getUid();
            midletName = ApplicationInfo.getInstance().getName();
            PushMidletData pushMidletDataObj = new PushMidletData(uidOfMidlet, midletName, aMIDletClassName, true);
            return pushMidletDataObj;
        }
        isClassNameOfThisMidlet = false;
        PushMidletData[] midletData = PushRegistryImpl.getMidletSuiteInformation(null);
        if (null == midletData) {
            throw new IOException("Retrieving MIDlet data failed");
        }
        boolean classNameMatched = false;
        for (int i = 0; i < midletData.length; ++i) {
            if (0 != aMIDletClassName.compareTo(midletData[i].mMainClass)) continue;
            classNameMatched = true;
            uidOfMidlet = midletData[i].mUid;
            midletName = midletData[i].mMidletName;
            break;
        }
        if (!classNameMatched) {
            throw new ClassNotFoundException("'midlet' argument, " + aMIDletClassName + ", is not a class name of any MIDlet in this suite");
        }
        return new PushMidletData(uidOfMidlet, midletName, aMIDletClassName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UidAndIsClassNameOfThisMidletInfo isValidConnToUnReg(String aConnection) throws IOException, ClassNotFoundException {
        Logger.LOG(8, 4, "PushRegistryImpl.isValidConnToUnReg()");
        StorageSession sessionObj = null;
        try {
            sessionObj = StorageFactory.createSession();
            sessionObj.open();
            PushInfo pushInfoObj = PushDbHandler.getPushRegByConnection(aConnection, sessionObj);
            if (null == pushInfoObj) {
                throw new ClassNotFoundException("Push connection has not been registered: " + aConnection);
            }
            Uid uidOfPushRegMidlet = pushInfoObj.getUid();
            if (ApplicationInfo.getInstance().getUid().equals(uidOfPushRegMidlet) && 0 == pushInfoObj.getRegType()) {
                UidAndIsClassNameOfThisMidletInfo uidAndIsClassNameOfThisMidletInfo = new UidAndIsClassNameOfThisMidletInfo(uidOfPushRegMidlet, true);
                return uidAndIsClassNameOfThisMidletInfo;
            }
            PushMidletData[] midletData = PushRegistryImpl.getMidletSuiteInformation(sessionObj);
            if (null == midletData) {
                throw new IOException("Retrieving MIDlet data failed");
            }
            boolean midletMatched = false;
            for (int i = 0; i < midletData.length; ++i) {
                if (!uidOfPushRegMidlet.equals(midletData[i].mUid)) continue;
                midletMatched = true;
                break;
            }
            if (!midletMatched) {
                throw new SecurityException("Connection '" + aConnection + "' is already registered by another MIDlet suite");
            }
            if (1 == pushInfoObj.getRegType()) {
                throw new ClassNotFoundException("Type of the push connection is 'static'");
            }
            UidAndIsClassNameOfThisMidletInfo uidAndIsClassNameOfThisMidletInfo = new UidAndIsClassNameOfThisMidletInfo(uidOfPushRegMidlet, false);
            return uidAndIsClassNameOfThisMidletInfo;
        }
        finally {
            if (null != sessionObj) {
                sessionObj.close();
                sessionObj.destroySession();
            }
        }
    }

    private static PushMidletData[] getMidletSuiteInformation(StorageSession aSession) throws IOException {
        Logger.LOG(8, 4, "PushRegistryImpl.getMidletSuiteInformation()");
        if (null == mMidletsInSuiteInfo) {
            Uid suiteUid = ApplicationInfo.getInstance().getSuiteUid();
            mMidletsInSuiteInfo = PushDbHandler.getClassNamesAndUidsOfMidletsInSuite(suiteUid, aSession);
        }
        return mMidletsInSuiteInfo;
    }

    private static native String getFilter0(String var0, String var1);

    private static native String getMIDlet0(String var0, String var1);

    private static native boolean isPushConnection0(String var0, String var1);

    private static native String[] listConnections0(boolean var0, String var1);

    private static native long registerAlarm0(long var0, String var2, String var3, boolean var4);

    private static native void registerConnection0(String var0, String var1, String var2, String var3, boolean var4);

    private static native boolean unregisterConnection0(String var0, String var1, boolean var2);

    static {
        Jvm.loadSystemLibrary("javapushregistry");
    }
}

