/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.rt.midp.ApplicationInfoImpl;
import com.nokia.mj.impl.rt.midp.Log;
import com.nokia.mj.impl.rt.midp.MidletApplicationBase;
import com.nokia.mj.impl.rt.midp.MidletLifeCycle;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.StartUpTrace;
import javax.microedition.midlet.MIDletStateChangeException;

final class MidletInvoker
implements Runnable {
    private static final int START_REQUEST = 1;
    private static final int STOP_REQUEST = 2;
    private static final int RESUME_REQUEST = 3;
    private static final int PAUSE_REQUEST = 4;
    private int mTask;

    private MidletInvoker(int task) {
        this.mTask = task;
    }

    private MidletInvoker() {
    }

    static void startMidlet() {
        new Thread(new MidletInvoker(1)).start();
    }

    static void resumeMidlet() {
        new Thread(new MidletInvoker(3)).start();
    }

    static void stopMidlet() {
        new Thread(new MidletInvoker(2)).start();
    }

    static void pauseMidlet() {
        new Thread(new MidletInvoker(4)).start();
    }

    public void run() {
        try {
            switch (this.mTask) {
                case 1: {
                    this.handleStartRequest();
                    break;
                }
                case 2: {
                    this.handleStopRequest();
                    break;
                }
                case 3: {
                    this.handleResumeRequest();
                    break;
                }
                case 4: {
                    this.handlePauseRequest();
                    break;
                }
                default: {
                    Log.logE("Unknown task in MidletInvoker! Task: " + this.mTask);
                    break;
                }
            }
        }
        catch (Throwable th) {
            Log.logE("Error in MidletInvoker! ", th);
        }
    }

    private void handleStartRequest() {
        MidletLifeCycle lifeCycle = MidletLifeCycle.getInstance();
        try {
            String className = ApplicationInfoImpl.getMidletInfo().getMainClass();
            StartUpTrace.doTrace("Starting MIDLET");
            Class clazz = Jvm.loadApplicationClass(className);
            Object midlet = clazz.newInstance();
            lifeCycle.getMidletApplication().invokeStartApp();
            StartUpTrace.doTrace("MIDLET returned from startApp()");
        }
        catch (Throwable th) {
            lifeCycle.handleMidletStartUpFailure(th);
        }
        lifeCycle.midletStarted();
    }

    private void handlePauseRequest() {
        MidletLifeCycle lifeCycle = MidletLifeCycle.getInstance();
        try {
            MidletApplicationBase midletApplication = lifeCycle.getMidletApplication();
            if (midletApplication != null) {
                midletApplication.invokePauseApp();
            }
        }
        catch (Throwable th) {
            Log.logE("Error in pauseApp! ", th);
            lifeCycle.handleUncaughtException(th);
        }
    }

    private void handleStopRequest() {
        MidletLifeCycle lifeCycle = MidletLifeCycle.getInstance();
        try {
            MidletApplicationBase midletApplication = lifeCycle.getMidletApplication();
            if (midletApplication != null) {
                midletApplication.invokeDestroyApp(true);
            }
        }
        catch (Throwable th) {
            Log.logE("Error in destroyApp! ", th);
        }
        lifeCycle.midletDestroyed();
    }

    private void handleResumeRequest() {
        MidletLifeCycle lifeCycle = MidletLifeCycle.getInstance();
        boolean ok = false;
        try {
            MidletApplicationBase midletApplication = lifeCycle.getMidletApplication();
            if (midletApplication != null) {
                midletApplication.invokeStartApp();
            }
            ok = true;
        }
        catch (MIDletStateChangeException me) {
        }
        catch (Throwable th) {
            Log.logE("Error when doing startApp when resuming! ", th);
        }
        lifeCycle.midletResumed(ok);
    }
}

