/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.comms.CommsEndpoint;
import com.nokia.mj.impl.comms.CommsListener;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.rt.midp.Log;
import com.nokia.mj.impl.rt.midp.MidletLifeCycle;
import com.nokia.mj.impl.utils.Uid;

final class MidpComms
implements CommsListener {
    private static final int PLUGIN_ID_RTC_C = 1;
    private static final int RTC_MSG_ID_LAUNCH_APPLICATION_REQ = 101;
    private static final int RTC_MSG_ID_TERMINATE_APPLICATION_REQ = 102;
    private static final int RTC_MSG_ID_APPLICATION_RUNNING_IND = 103;
    private static final int RTC_MSG_ID_APPLICATION_TERMINATED_IND = 104;
    private static final int RTC_LAUNCH_TYPE_BACKGROUND_C = 4;
    private static final int PLUGIN_ID_PMC_C = 9;
    private static final int PMC_MSG_ID_PROCESS_INITIALISED_IND = 121;
    private Uid mMidletUid;
    private CommsEndpoint mComms = CommsEndpoint.find("javacaptain");

    MidpComms() {
        this.mComms.registerListener(1, this);
    }

    MidpComms(Uid midletUid) {
        this();
        this.mMidletUid = midletUid;
    }

    synchronized void close() {
        if (this.mComms != null) {
            this.mComms.unregisterListener(1);
            this.mComms.destroy();
        }
        this.mComms = null;
    }

    synchronized void sendRunningIndication(int status) {
        CommsMessage message = new CommsMessage();
        message.setModuleId(1);
        message.setMessageId(103);
        message.write(this.mMidletUid.toString());
        message.write(status);
        this.mComms.send(message);
    }

    synchronized void sendProcessRunningIndication(int pid) {
        CommsMessage message = new CommsMessage();
        message.setModuleId(9);
        message.setMessageId(121);
        message.write(pid);
        this.mComms.send(message);
    }

    synchronized void sendTerminatedIndication(int status) {
        CommsMessage message = new CommsMessage();
        message.setModuleId(1);
        message.setMessageId(104);
        message.write(this.mMidletUid.toString());
        message.write(status);
        this.mComms.send(message);
    }

    public void processMessage(CommsMessage message) {
        switch (message.getMessageId()) {
            case 101: {
                String uidString = message.readString();
                Uid uid = Uid.createUid(uidString);
                int type = message.readInt();
                int options = message.readInt();
                String rlc = message.readString();
                if (this.mMidletUid == null) {
                    this.mMidletUid = uid;
                }
                if (this.mMidletUid.equals(uid)) {
                    boolean backGround = false;
                    if (type == 4) {
                        backGround = true;
                    }
                    MidletLifeCycle.getInstance().launchMidletRequest(uid, backGround);
                    break;
                }
                Log.logE("Comms (launchReq) with illegal UID, rlc=" + rlc + ", uid(recv)=" + uid + ", midletUid=" + this.mMidletUid + ", type=" + type + ", options=" + options);
                break;
            }
            case 102: {
                String uidString = message.readString();
                Uid uid = Uid.createUid(uidString);
                int options = message.readInt();
                if (this.mMidletUid.equals(uid)) {
                    MidletLifeCycle.getInstance().terminateMidletRequest(false);
                    break;
                }
                Log.logE("Comms (terminatreReq) with illegal UID, , uid(recv)=" + uid + ", midletUid=" + this.mMidletUid + ", options=" + options);
                break;
            }
            default: {
                Log.logE("Comms, Unknow message received (MIDP JAVA RT): , messageId=" + message.getMessageId() + ", moduleId=" + message.getModuleId());
            }
        }
    }
}

