/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security;

import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.security.PublicKeyImpl;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactoryImpl {
    private String iAlgorithm;

    public KeyFactoryImpl(String aAlgorithm) throws NoSuchAlgorithmException {
        if (!KeyFactoryImpl._isValidAlgorithm(aAlgorithm.toUpperCase())) {
            throw new NoSuchAlgorithmException("Unsupported algorithm: " + aAlgorithm);
        }
        this.iAlgorithm = aAlgorithm;
    }

    public final PublicKey generatePublic(KeySpec aKeySpec) throws InvalidKeySpecException {
        byte[] encoded = null;
        String format = null;
        if (!(aKeySpec instanceof EncodedKeySpec)) {
            throw new InvalidKeySpecException("PublicKey generation failed: KeySpec type is not supported");
        }
        EncodedKeySpec encodedKeySpec = (EncodedKeySpec)aKeySpec;
        encoded = encodedKeySpec.getEncoded();
        format = encodedKeySpec.getFormat();
        if (encoded == null || format == null) {
            throw new InvalidKeySpecException("PublicKey generation failed: format or encoded key is null");
        }
        int ret = KeyFactoryImpl._isValidKey(this.iAlgorithm.toUpperCase(), format.toUpperCase(), encoded);
        if (ret < 0) {
            throw new InvalidKeySpecException("PublicKey generation failed: invalid key specification");
        }
        return new PublicKeyImpl(this.iAlgorithm, encoded, format);
    }

    private static native boolean _isValidAlgorithm(String var0);

    private static native int _isValidKey(String var0, String var1, byte[] var2);

    static {
        try {
            Jvm.loadSystemLibrary("javasatsa");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

