/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.appaccessauthorization;

import com.nokia.mj.impl.security.midp.common.AuthorizationRestriction;
import com.nokia.mj.impl.security.midp.storage.AppAccessAuthorizationStorageData;
import com.nokia.mj.impl.security.midp.storage.SecurityStorage;
import com.nokia.mj.impl.utils.Uid;

public final class ApplicationAccessAuthorization {
    public static final int ACCESS_ALLOWED = 1;
    public static final int ACCESS_DENIED = 2;

    public static int checkAccess(Uid msUID_A, Uid msUID_B) {
        if (msUID_A == null) {
            return 2;
        }
        if (msUID_B == null) {
            return 1;
        }
        if (msUID_A.equals(msUID_B)) {
            return 1;
        }
        SecurityStorage storage = new SecurityStorage();
        AuthorizationRestriction[] restrictionList = storage.readAuthorizationRestrictions(msUID_B);
        if (restrictionList == null || restrictionList.length == 0) {
            return 1;
        }
        AppAccessAuthorizationStorageData sData = storage.readAppAccessAuthorizationStorageData(msUID_A);
        String vendorName = null;
        String domainName = null;
        String[] signers = null;
        if (sData != null) {
            vendorName = sData.getVendorName();
            domainName = sData.getDomainName();
            signers = sData.getSignersList();
        }
        for (int i = 0; i < restrictionList.length; ++i) {
            String vendor = restrictionList[0].getVendor();
            if (!vendor.equalsIgnoreCase("any") && !vendor.equalsIgnoreCase(vendorName)) continue;
            String domain = restrictionList[0].getDomain();
            if (domain.equalsIgnoreCase("self")) {
                domain = storage.readProtectionDomain(msUID_B);
            }
            if (domain == null || !domain.equalsIgnoreCase("any") && !domain.equalsIgnoreCase(domainName)) continue;
            String signer = restrictionList[0].getSigner();
            if (signer.equalsIgnoreCase("any")) {
                return 1;
            }
            if (signers == null) continue;
            for (int j = 0; j < signers.length; ++j) {
                if (!signer.equalsIgnoreCase(signers[j])) continue;
                return 1;
            }
        }
        return 2;
    }
}

