/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.common;

import com.nokia.mj.impl.security.midp.common.MIDPPermission;
import com.nokia.mj.impl.security.midp.common.PermissionMappingTable;
import com.nokia.mj.impl.security.utils.Logger;
import com.nokia.mj.impl.utils.JavaLanguageSyntaxChecker;
import com.nokia.mj.impl.utils.Tokenizer;
import com.nokia.mj.impl.utils.exception.InvalidAttributeException;
import java.util.Vector;

public abstract class PermissionAttribute
extends MIDPPermission {
    public static final int MANDATORY_PERMISSION = 1;
    public static final int OPTIONAL_PERMISSION = 2;
    public static final String OPTIONAL_ATTRIBUTE_PREFIX = "MIDlet-Permission-Opt-";
    public static final String OPTIONAL_LEGACY_ATTRIBUTE_NAME = "MIDlet-Permissions-Opt";
    public static final String MANDATORY_ATTRIBUTE_PREFIX = "MIDlet-Permission-";
    public static final String MANDATORY_LEGACY_ATTRIBUTE_NAME = "MIDlet-Permissions";
    private String attrName = null;

    PermissionAttribute(String attrName, String attrValue) {
        String[] tokens = Tokenizer.split(attrValue, " ");
        if (tokens == null || tokens.length > 3) {
            int i = 0;
            i = this.skipSpaces(attrValue, i);
            this.name = this.readChars(attrValue, i);
            i += this.name.length();
            i = this.skipSpaces(attrValue, i);
            this.target = this.readChars(attrValue, i);
            i += this.target.length();
            i = this.skipSpaces(attrValue, i);
            this.actionList = this.readChars(attrValue, i);
            i += this.actionList.length();
            if ((i = this.skipSpaces(attrValue, i)) < attrValue.length()) {
                throw new InvalidAttributeException(3, null, 7, new String[]{attrName}, 909);
            }
            if (this.name.length() == 0) {
                this.name = null;
            }
            if (this.target.length() == 0) {
                this.target = null;
            }
            if (this.actionList.length() == 0) {
                this.actionList = null;
            }
        } else {
            switch (tokens.length) {
                case 3: {
                    this.actionList = tokens[2];
                }
                case 2: {
                    this.target = tokens[1];
                }
                case 1: {
                    this.name = tokens[0];
                }
            }
        }
        MIDPPermission internalPerm = PermissionMappingTable.get(this.name);
        if (internalPerm != null) {
            this.name = internalPerm.getName();
        }
        if (!JavaLanguageSyntaxChecker.checkClassName(this.name)) {
            throw new InvalidAttributeException(3, null, 7, new String[]{attrName}, 909);
        }
        this.attrName = attrName;
    }

    PermissionAttribute(String name, String target, String actionList, String attrName) {
        super(name, target, actionList);
        this.attrName = attrName;
    }

    PermissionAttribute(String attrName) {
        this.attrName = attrName;
    }

    public abstract int getImportance();

    public abstract String toString();

    public String getAttributeName() {
        return this.attrName;
    }

    public boolean isLegacyAttribute() {
        return this.attrName != null && (this.attrName.equalsIgnoreCase(MANDATORY_LEGACY_ATTRIBUTE_NAME) || this.attrName.equalsIgnoreCase(OPTIONAL_LEGACY_ATTRIBUTE_NAME));
    }

    protected static MIDPPermission[] InitFromLegacyAttribute(String attrName, String attrValue, boolean ignoreUnknownValues) {
        String[] legacyPerms = Tokenizer.split(attrValue, ",");
        if (legacyPerms == null || legacyPerms.length == 0) {
            throw new InvalidAttributeException(3, null, 7, new String[]{attrName}, 909);
        }
        Vector midp3Perms = new Vector();
        for (int i = 0; i < legacyPerms.length; ++i) {
            legacyPerms[i] = legacyPerms[i].trim();
            MIDPPermission midp3Perm = PermissionMappingTable.get(legacyPerms[i]);
            if (midp3Perm == null) {
                if (ignoreUnknownValues) continue;
                Logger.logError("Permission " + legacyPerms[i] + " not supported");
                throw new InvalidAttributeException(3, null, 6, new String[]{attrName}, 910);
            }
            if (midp3Perms.contains(midp3Perm)) continue;
            midp3Perms.addElement(midp3Perm);
        }
        Object[] perms = new MIDPPermission[midp3Perms.size()];
        midp3Perms.copyInto(perms);
        return perms;
    }

    private int skipSpaces(String str, int startIndex) {
        while (startIndex < str.length() && str.charAt(startIndex) == ' ') {
            ++startIndex;
        }
        return startIndex;
    }

    private String readChars(String str, int startIndex) {
        String rStr = "";
        while (startIndex < str.length() && str.charAt(startIndex) != ' ') {
            rStr = rStr + str.charAt(startIndex);
            ++startIndex;
        }
        return rStr;
    }
}

