/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.sensor;

import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.MeasurementRange;
import javax.microedition.sensor.Unit;

public class ChannelInfoImpl
implements ChannelInfo {
    private static final String SCHEME_SEP = "#";
    private static final String INVALID_CHANNELINFO = "Invalid channel info string";
    private String iName;
    private MeasurementRange[] iMeasurementRanges;
    private int iScale;
    private Unit iUnit;
    private float iAccuracy;
    private int iDataType;

    public ChannelInfoImpl(String aChannelInfo) {
        int start = 0;
        int end = aChannelInfo.indexOf(SCHEME_SEP);
        if (end <= 0) {
            throw new IllegalArgumentException(INVALID_CHANNELINFO);
        }
        this.iName = aChannelInfo.substring(start, end);
        start = end + 1;
        if ((end = aChannelInfo.indexOf(SCHEME_SEP, start)) <= 0) {
            throw new IllegalArgumentException(INVALID_CHANNELINFO);
        }
        this.iAccuracy = Float.parseFloat(aChannelInfo.substring(start, end));
        start = end + 1;
        if ((end = aChannelInfo.indexOf(SCHEME_SEP, start)) <= 0) {
            throw new IllegalArgumentException(INVALID_CHANNELINFO);
        }
        int dataType = Integer.parseInt(aChannelInfo.substring(start, end));
        if (dataType != 1 && dataType != 2 && dataType != 4) {
            throw new IllegalArgumentException(INVALID_CHANNELINFO);
        }
        this.iDataType = dataType;
        start = end + 1;
        if ((end = aChannelInfo.indexOf(SCHEME_SEP, start)) <= 0) {
            throw new IllegalArgumentException(INVALID_CHANNELINFO);
        }
        this.iScale = Integer.parseInt(aChannelInfo.substring(start, end));
        start = end + 1;
        if ((end = aChannelInfo.indexOf(SCHEME_SEP, start)) <= 0) {
            throw new IllegalArgumentException(INVALID_CHANNELINFO);
        }
        this.iUnit = Unit.getUnit(aChannelInfo.substring(start, end));
        start = end + 1;
        if ((end = aChannelInfo.indexOf(SCHEME_SEP, start)) <= 0) {
            throw new IllegalArgumentException(INVALID_CHANNELINFO);
        }
        int measurementRangeCount = Integer.parseInt(aChannelInfo.substring(start, end));
        this.iMeasurementRanges = new MeasurementRange[measurementRangeCount];
        for (int i = 0; i < measurementRangeCount; ++i) {
            start = end + 1;
            if ((end = aChannelInfo.indexOf(SCHEME_SEP, start)) <= 0) {
                throw new IllegalArgumentException(INVALID_CHANNELINFO);
            }
            double msrSmallest = Double.parseDouble(aChannelInfo.substring(start, end));
            start = end + 1;
            if ((end = aChannelInfo.indexOf(SCHEME_SEP, start)) <= 0) {
                throw new IllegalArgumentException(INVALID_CHANNELINFO);
            }
            double msrLargest = Double.parseDouble(aChannelInfo.substring(start, end));
            start = end + 1;
            if ((end = aChannelInfo.indexOf(SCHEME_SEP, start)) <= 0) {
                throw new IllegalArgumentException(INVALID_CHANNELINFO);
            }
            double msrResolution = Double.parseDouble(aChannelInfo.substring(start, end));
            this.iMeasurementRanges[i] = new MeasurementRange(msrSmallest, msrLargest, msrResolution);
        }
    }

    public float getAccuracy() {
        return this.iAccuracy;
    }

    public int getDataType() {
        return this.iDataType;
    }

    public String getName() {
        return this.iName;
    }

    public MeasurementRange[] getMeasurementRanges() {
        return this.iMeasurementRanges;
    }

    public int getScale() {
        return this.iScale;
    }

    public Unit getUnit() {
        return this.iUnit;
    }
}

