/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.socket;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.gcf.utils.StreamConnectionBase;
import com.nokia.mj.impl.gcf.utils.UrlParser;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.utils.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.SocketConnection;

public class SocketConnectionImpl
extends StreamConnectionBase
implements SocketConnection {
    private UrlParser iUri;
    private Finalizer iFinalizer;
    private boolean iConnectionOpen = false;
    private boolean iOutputStreamOpenedOnce = false;
    private boolean iInputStreamOpenedOnce = false;
    private boolean iDataOutputStreamOpenedOnce = false;
    private boolean iDataInputStreamOpenedOnce = false;
    private ConnectionManager iCmInstance = null;
    private AccessPoint iApn = null;

    public SocketConnectionImpl(UrlParser aUri, int aMode, int aSock, ConnectionManager cm, AccessPoint apnInfo) throws IOException {
        super(aUri.toString(), aMode, false);
        this.iCmInstance = cm;
        this.iApn = apnInfo;
        Logger.LOG(14, 4, "+SocketConnectionImpl::SocketConnectionImpl()");
        int ret = 0;
        if (this.iNativePeerHandle == 0) {
            throw new IOException("Unable to open socket connection: failed to create native peer ");
        }
        int[] retval = new int[1];
        ret = this.iApn != null ? this._openSocket(this.iNativePeerHandle, aSock, this.iApn.getType(), this.iApn.getNapId(), retval) : this._openSocket(this.iNativePeerHandle, aSock, -1, -1, retval);
        Logger.LOG(14, 4, "setting access point return value =" + retval[0]);
        if (this.iCmInstance != null && retval[0] < 0) {
            this.iCmInstance.reset();
        }
        if (ret < 0) {
            throw new IOException("Unable to open socket connection. POSIX error code: " + ret);
        }
        this.iConnectionOpen = true;
        Logger.LOG(14, 4, "SocketConnectionImpl::SocketConnectionImpl(): _openSocket return value " + ret);
        this.iFinalizer = this.createFinalizer();
        Logger.LOG(14, 4, "-SocketConnectionImpl::SocketConnectionImpl()");
    }

    public String getAddress() throws IOException {
        Logger.LOG(14, 4, "+SocketConnectionImpl::getAddress()");
        String[] addr = new String[1];
        if (!this.iConnectionOpen) {
            throw new IOException("getAddress failed: connection is already closed");
        }
        int retValue = this._getAddress(this.iNativePeerHandle, addr);
        if (retValue < 0) {
            throw new IOException("getAddress failed. POSIX error code: " + retValue);
        }
        Logger.LOG(14, 4, "-SocketConnectionImpl::getAddress()");
        return addr[0];
    }

    public String getLocalAddress() throws IOException {
        Logger.LOG(14, 4, "+SocketConnectionImpl::getLocalAddress()");
        String[] addr = new String[1];
        if (!this.iConnectionOpen) {
            throw new IOException("getLocalAddress failed: connection is already closed");
        }
        int retValue = this._getLocalAddress(this.iNativePeerHandle, addr);
        if (retValue < 0) {
            throw new IOException("getLocalAddress failed. POSIX error code: " + retValue);
        }
        Logger.LOG(14, 4, "-SocketConnectionImpl::getLocalAddress()");
        return addr[0];
    }

    public int getLocalPort() throws IOException {
        Logger.LOG(14, 4, "+SocketConnectionImpl::getLocalPort()");
        if (!this.iConnectionOpen) {
            throw new IOException("getLocalPort failed: connection is already closed");
        }
        int result = this._getLocalPort(this.iNativePeerHandle);
        if (result < 0) {
            throw new IOException("getLocalPort failed. POSIX error code: " + result);
        }
        Logger.LOG(14, 4, "-SocketConnectionImpl::getLocalPort()");
        return result;
    }

    public int getPort() throws IOException {
        Logger.LOG(14, 4, "+SocketConnectionImpl::getPort()");
        if (!this.iConnectionOpen) {
            throw new IOException("getPort failed: connection is already closed");
        }
        int retVal = this._getport(this.iNativePeerHandle);
        if (retVal < 0) {
            throw new IOException("getPort failed. POSIX error code: " + retVal);
        }
        Logger.LOG(14, 4, "-SocketConnectionImpl::getPort()");
        return retVal;
    }

    public int getSocketOption(byte aOption) throws IllegalArgumentException, IOException {
        Logger.LOG(14, 4, "+SocketConnectionImpl::getSocketOption()");
        if (!this.iConnectionOpen) {
            throw new IOException("getSocketOption failed: connection is already closed");
        }
        this.checkOption(aOption);
        int retVal = this._getSocketOption(this.iNativePeerHandle, aOption);
        if (retVal < 0) {
            throw new IOException("getSocketOption failed. POSIX error code: " + retVal);
        }
        Logger.LOG(14, 4, "-SocketConnectionImpl::getSocketOption()");
        return retVal;
    }

    public void setSocketOption(byte aOption, int aValue) throws IllegalArgumentException, IOException {
        Logger.LOG(14, 4, "+SocketConnectionImpl::setSocketOption()");
        if (!this.iConnectionOpen) {
            throw new IOException("setSocketOption failed: connection is already closed");
        }
        this.checkOption(aOption);
        if (aValue < 0) {
            throw new IllegalArgumentException("Invalid value for setSocketOption method");
        }
        int retVal = this._setSocketOption(this.iNativePeerHandle, aOption, aValue);
        if (retVal < 0) {
            throw new IOException("setSocketOption failed. POSIX error code: " + retVal);
        }
        Logger.LOG(14, 4, "-SocketConnectionImpl::setSocketOption()");
    }

    private void checkOption(byte option) throws IllegalArgumentException {
        if (option != 0 && option != 2 && option != 1 && option != 3 && option != 4) {
            throw new IllegalArgumentException("Unsupported socket option");
        }
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.iOutputStreamOpenedOnce) {
            throw new IOException("OutputStream cannot be opened multiple times");
        }
        this.iOutputStreamOpenedOnce = true;
        return super.openOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        if (this.iDataOutputStreamOpenedOnce) {
            throw new IOException("DataOutputStream cannot be opened multiple times");
        }
        this.iDataOutputStreamOpenedOnce = true;
        return super.openDataOutputStream();
    }

    public InputStream openInputStream() throws IOException {
        if (this.iInputStreamOpenedOnce) {
            throw new IOException("InputStream cannot be opened multiple times");
        }
        this.iInputStreamOpenedOnce = true;
        return super.openInputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        if (this.iDataInputStreamOpenedOnce) {
            throw new IOException("DataInputStream cannot be opened multiple times");
        }
        this.iDataInputStreamOpenedOnce = true;
        return super.openDataInputStream();
    }

    public synchronized void close() throws IOException {
        Logger.LOG(14, 4, "+SocketConnectionImpl::Close()");
        if (this.iConnectionOpen) {
            int ret;
            this.iConnectionOpen = false;
            super.close();
            if (this.isStreamsClosed() && (ret = this._close(this.iNativePeerHandle)) != 0) {
                throw new IOException("close failed. POSIX error code: " + ret);
            }
        }
        Logger.LOG(14, 4, "-SocketConnectionImpl::Close()");
    }

    public int createNativePeer(String aUri, int aMode, boolean aTimeout) {
        Logger.LOG(14, 4, "+SocketConnectionImpl::createNativePeer()");
        int ret = 0;
        this.iUri = new UrlParser(aUri);
        Logger.LOG(14, 4, "SocketConnectionImpl::createNativePeer() aUri = " + aUri + "aMode = " + aMode + "iUri.host = " + this.iUri.host);
        if (this.iUri.host == null) {
            ret = this._createNativePeer(aUri, aMode, "", this.iUri.port);
        }
        ret = this._createNativePeer(aUri, aMode, this.iUri.host, this.iUri.port);
        Logger.LOG(14, 4, "-SocketConnectionImpl::createNativePeer()");
        return ret;
    }

    Finalizer createFinalizer() {
        Logger.LOG(14, 4, "creating a socket finalizer object ");
        return new Finalizer(){

            public void finalizeImpl() {
                SocketConnectionImpl.this.doFinalize();
            }
        };
    }

    public void doFinalize() {
        Logger.LOG(14, 4, "socket doFinalize() called :");
        if (this.iConnectionOpen) {
            this.iConnectionOpen = false;
            if (this.iNativePeerHandle != 0) {
                int n = this._close(this.iNativePeerHandle);
            }
        }
        if (this.iNativePeerHandle != 0) {
            this._dispose(this.iNativePeerHandle);
            this.iNativePeerHandle = 0;
        }
    }

    private native int _createNativePeer(String var1, int var2, String var3, int var4);

    private native int _openSocket(int var1, int var2, int var3, int var4, int[] var5);

    private native int _getport(int var1);

    private native int _getLocalPort(int var1);

    private native int _getSocketOption(int var1, int var2);

    private native int _setSocketOption(int var1, int var2, int var3);

    private native int _getLocalAddress(int var1, String[] var2);

    private native int _getAddress(int var1, String[] var2);

    private native int _close(int var1);

    private native void _dispose(int var1);
}

