/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.storage;

import com.nokia.mj.impl.storage.StorageAttribute;
import com.nokia.mj.impl.storage.StorageException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class StorageEntry {
    private Hashtable iAttributes = new Hashtable();

    public void addAttribute(StorageAttribute aAttribute) throws StorageException {
        if (aAttribute == null) {
            throw new StorageException("Invalid argument");
        }
        this.iAttributes.put(aAttribute.getName(), aAttribute);
    }

    public Enumeration elements() {
        return this.iAttributes.elements();
    }

    public StorageAttribute getAttribute(String aName) throws StorageException {
        if (aName == null || aName.equals("")) {
            throw new StorageException("Invalid argument name");
        }
        return (StorageAttribute)this.iAttributes.get(aName);
    }

    public boolean removeAttribute(StorageAttribute aAttribute) {
        if (null == aAttribute) {
            return false;
        }
        return this.removeAttribute(aAttribute.getName());
    }

    public boolean removeAttribute(String aName) {
        StorageAttribute attr;
        boolean success = false;
        if (aName != null && (attr = (StorageAttribute)this.iAttributes.remove(aName)) != null) {
            success = true;
        }
        return success;
    }

    public void removeAll() {
        this.iAttributes.clear();
    }

    public int size() {
        return this.iAttributes.size();
    }

    public String toString() {
        return this.iAttributes.toString();
    }
}

