/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.tckrunner;

import com.nokia.mj.impl.comms.CommsEndpoint;
import com.nokia.mj.impl.comms.CommsListener;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.comms.exception.CommsException;
import com.nokia.mj.impl.tckrunner.TckRunnerException;
import com.nokia.mj.impl.utils.Logger;

public class Launcher {
    private static final int PLUGIN_ID_RTC = 1;
    private static final int RTC_MSG_ID_LAUNCH_APPLICATION_REQ = 101;
    private static final int RTC_LAUNCH_TYPE_NORMAL_C = 0;
    private static final int RTC_LAUNCH_OPTIONS_TERMINATE_IND_REQ_C = 2;
    private CommsEndpoint iComms = null;
    private int iUidIndex = 0;
    private String[] iUids = null;

    public Launcher(CommsListener aListener) {
        try {
            this.iComms = new CommsEndpoint();
            this.iComms.registerDefaultListener(aListener);
            this.iComms.connect(10000);
        }
        catch (Exception e) {
            throw new TckRunnerException("Launcher constructor failed. Unable to connect to JavaCaptain", e);
        }
    }

    public void close() {
        try {
            this.iComms.unregisterDefaultListener();
            this.iComms.disconnect();
            this.iComms.destroy();
        }
        catch (Exception e) {
            Logger.LOG(18, 4, "Launcher close failed", e);
        }
    }

    public boolean runNext() {
        if (this.iUidIndex >= this.iUids.length) {
            return true;
        }
        try {
            CommsMessage msg = new CommsMessage();
            msg.setMessageId(101);
            msg.setModuleId(1);
            msg.write(this.iUids[this.iUidIndex]);
            msg.write(0);
            msg.write(2);
            msg.write("midp");
            msg.write("");
            msg.write("");
            Logger.LOG(18, 4, "LaunchApplicationReq: uid=" + this.iUids[this.iUidIndex]);
            this.iComms.send(msg);
            ++this.iUidIndex;
            return false;
        }
        catch (CommsException ce) {
            throw new TckRunnerException("Message sending to Java Captain failed", ce);
        }
    }

    public void setApplications(String[] aUids) {
        this.iUids = aUids;
        this.iUidIndex = 0;
    }

    public String getUidForUninstallation() {
        return this.iUids[0];
    }
}

