/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.tckrunner;

import com.nokia.mj.impl.tckrunner.TckRunner;
import com.nokia.mj.impl.tckrunner.TckRunnerStateListener;
import com.nokia.mj.impl.utils.Logger;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TckRunnerUi
implements TckRunnerStateListener {
    private Text iUrl;
    private Label iStatus;
    private String iURL;
    private int iState;
    private int iRetryCount;
    private TckRunner iTckRunner = new TckRunner();
    private Thread iTckRunnerThread;
    private boolean iRunning = false;
    private boolean iExiting = false;

    public TckRunnerUi() {
        this.iTckRunner.setListener(this);
    }

    public void show() {
        Display display = new Display();
        Shell shell = new Shell(display);
        this.createUi(shell);
        shell.pack();
        shell.open();
        while (!this.iExiting) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void exitEventLoop() {
        this.iExiting = true;
        Display.getDefault().wake();
    }

    private void createUi(Shell shell) {
        try {
            shell.setText("TCK Runner");
            RowLayout layout = new RowLayout();
            layout.type = 512;
            layout.pack = false;
            shell.setLayout((Layout)layout);
            new Label((Composite)shell, 0).setText("Set TCK Harness URL:");
            this.iUrl = new Text((Composite)shell, 0);
            this.iUrl.setText("http://server:8080/test/getNextApp.jad");
            new Label((Composite)shell, 0).setText("TCK Runner State:");
            this.iStatus = new Label((Composite)shell, 0);
            this.iStatus.setText("Not running");
            Command start = new Command((Control)shell, 3, 0);
            start.setText("Start");
            start.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent aEvent) {
                    this.widgetSelected(aEvent);
                }

                public void widgetSelected(SelectionEvent event) {
                    TckRunnerUi.this.iStatus.setText("Starting...");
                    TckRunnerUi.this.startTckRunner();
                }
            });
            Command stop = new Command((Control)shell, 3, 0);
            stop.setText("Stop");
            stop.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent aEvent) {
                    this.widgetSelected(aEvent);
                }

                public void widgetSelected(SelectionEvent event) {
                    TckRunnerUi.this.iStatus.setText("Stopping...");
                    TckRunnerUi.this.stopTckRunner();
                }
            });
            Command exit = new Command((Control)shell, 7, 0);
            exit.setText("Exit");
            exit.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent aEvent) {
                    this.widgetSelected(aEvent);
                }

                public void widgetSelected(SelectionEvent aEvent) {
                    TckRunnerUi.this.iStatus.setText("exit pressed");
                    TckRunnerUi.this.stopTckRunner();
                    TckRunnerUi.this.exitEventLoop();
                }
            });
        }
        catch (Throwable e) {
            Logger.ELOG(18, "createUi failed", e);
            this.exitEventLoop();
        }
    }

    private void startTckRunner() {
        if (!this.iRunning) {
            this.iURL = this.iUrl.getText();
            this.iTckRunnerThread = new Thread(new Runnable(){

                public void run() {
                    String[] aArgs = new String[]{};
                    TckRunnerUi.this.iTckRunner.start(TckRunnerUi.this.iURL, aArgs);
                    TckRunnerUi.this.iRunning = false;
                }
            });
            this.iRunning = true;
            this.iTckRunnerThread.start();
        } else {
            this.iStatus.setText("Started");
        }
    }

    private void stopTckRunner() {
        if (this.iRunning) {
            this.iTckRunner.stop();
            try {
                this.iTckRunnerThread.join();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.iStatus.setText("Stopped");
        }
    }

    public void stateChanged(int aState) {
        this.iState = aState;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!TckRunnerUi.this.iStatus.isDisposed()) {
                    TckRunnerUi.this.iStatus.setText(TckRunnerUi.this.stateToString(TckRunnerUi.this.iState));
                }
            }
        });
    }

    public void operationFailed(int aState, int aRetryCount) {
        this.iState = aState;
        this.iRetryCount = aRetryCount;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!TckRunnerUi.this.iStatus.isDisposed()) {
                    TckRunnerUi.this.iStatus.setText(TckRunnerUi.this.stateToString(TckRunnerUi.this.iState) + " - retry " + TckRunnerUi.this.iRetryCount);
                }
            }
        });
    }

    private String stateToString(int aState) {
        String state;
        switch (aState) {
            case 1: {
                state = "Downloading TCK Agent";
                break;
            }
            case 2: {
                state = "Removing TCK Agent";
                break;
            }
            case 3: {
                state = "Running TCK Agent";
                break;
            }
            case 0: {
                state = "Not running";
                break;
            }
            default: {
                state = "";
            }
        }
        return state;
    }
}

