/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.utils;

import com.nokia.mj.impl.utils.Logger;
import java.util.Date;

public class Formatter {
    private String pattern;
    private String replaced;
    private int nextIndex = 0;

    public Formatter(String aPattern) {
        this.pattern = aPattern;
        this.replaced = aPattern;
    }

    public Formatter arg(String string) {
        if (this.replace("%" + this.nextIndex + "U", string) || this.replace("%" + this.nextIndex, string) || this.replace("%U", string)) {
            ++this.nextIndex;
        } else {
            Logger.WLOG(6, "String replacement failed");
        }
        return this;
    }

    public Formatter arg(int number) {
        String localisedNumber = this._formatInteger(number);
        if (this.replace("%" + this.nextIndex + "N", localisedNumber) || this.replace("%" + this.nextIndex, localisedNumber) || this.replace("%N", localisedNumber)) {
            ++this.nextIndex;
        } else {
            Logger.WLOG(6, "Integer replacement failed");
        }
        return this;
    }

    public Formatter arg(char ch) {
        String chString = new String(new char[]{ch});
        if (this.replace("%" + this.nextIndex + "C", chString) || this.replace("%" + this.nextIndex, chString) || this.replace("%C", chString)) {
            ++this.nextIndex;
        } else {
            Logger.WLOG(6, "Character replacement failed");
        }
        return this;
    }

    public Formatter arg(Date date) {
        String dateString = this._formatDate(date.getTime());
        return this.arg(dateString);
    }

    public Formatter arg(Object o) {
        if (o != null) {
            if (o instanceof String) {
                return this.arg((String)o);
            }
            if (o instanceof Integer) {
                return this.arg((Integer)o);
            }
            if (o instanceof Character) {
                return this.arg(((Character)o).charValue());
            }
            if (o instanceof Date) {
                return this.arg((Date)o);
            }
        }
        return this;
    }

    public String toString() {
        String result = this.replaced;
        this.replaced = this.pattern;
        this.nextIndex = 0;
        return result;
    }

    public Formatter getClone() {
        return new Formatter(this.pattern);
    }

    public String format(Object[] textParameters) {
        if (textParameters != null) {
            for (int i = 0; i < textParameters.length; ++i) {
                if (textParameters[i] instanceof String) {
                    this.arg((String)textParameters[i]);
                    continue;
                }
                if (textParameters[i] instanceof Integer) {
                    this.arg((Integer)textParameters[i]);
                    continue;
                }
                if (textParameters[i] instanceof Date) {
                    this.arg((Date)textParameters[i]);
                    continue;
                }
                this.arg(textParameters[i]);
            }
        }
        return this.toString();
    }

    private boolean replace(String pattern, String replacement) {
        int index = this.replaced.indexOf(pattern);
        if (index != -1) {
            if (this.replaced.indexOf(pattern + "[]") != -1) {
                this.replaced = this.replaced.substring(0, index) + replacement + this.replaced.substring(index + pattern.length() + 2);
            } else {
                if (this.replaced.indexOf(pattern + "[") != -1) {
                    return this.replaceWithMax(pattern, replacement, index);
                }
                this.replaced = this.replaced.substring(0, index) + replacement + this.replaced.substring(index + pattern.length());
            }
            return true;
        }
        return false;
    }

    private boolean replaceWithMax(String pattern, String replacement, int maxIndex) {
        boolean result = false;
        int closingIndex = maxIndex + pattern.length() + 3;
        if (this.replaced.length() > closingIndex && this.replaced.charAt(closingIndex) == ']') {
            try {
                int maxLen = Integer.parseInt(this.replaced.substring(maxIndex + pattern.length() + 1, closingIndex));
                if (maxLen > replacement.length()) {
                    maxLen = replacement.length();
                }
                this.replaced = this.replaced.substring(0, maxIndex) + replacement.substring(0, maxLen) + this.replaced.substring(maxIndex + pattern.length() + 4);
                result = true;
            }
            catch (NumberFormatException nfe) {
                Logger.WLOG(6, "Replace with max failed to invalid replacement amount");
            }
        }
        return result;
    }

    private native String _formatInteger(int var1);

    private native String _formatDate(long var1);
}

