/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ukit.jaxp;

import com.sun.ukit.jaxp.Parser;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ParserFactory
extends SAXParserFactory {
    public static final String FEATURE_NS = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_PREF = "http://xml.org/sax/features/namespace-prefixes";
    private boolean namespaces = false;
    private boolean prefixes = true;

    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        if (this.namespaces && !this.prefixes) {
            return new Parser(true);
        }
        if (!this.namespaces && this.prefixes) {
            return new Parser(false);
        }
        throw new ParserConfigurationException("");
    }

    public void setNamespaceAware(boolean awareness) {
        super.setNamespaceAware(awareness);
        if (awareness) {
            this.namespaces = true;
            this.prefixes = false;
        } else {
            this.namespaces = false;
            this.prefixes = true;
        }
    }

    public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (FEATURE_NS.equals(name)) {
            this.namespaces = value;
        } else if (FEATURE_PREF.equals(name)) {
            this.prefixes = value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (FEATURE_NS.equals(name)) {
            return this.namespaces;
        }
        if (FEATURE_PREF.equals(name)) {
            return this.prefixes;
        }
        throw new SAXNotRecognizedException(name);
    }
}

