/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.j2me.midp.runtimeV2;

import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import com.nokia.mj.impl.utils.Logger;
import com.symbian.j2me.framework.service.app.Container;
import com.symbian.j2me.framework.service.midp.app.MIDPApplication;
import com.symbian.j2me.framework.service.midp.app.MIDPApplicationListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.midlet.MIDlet;

public class Application
implements MIDPApplication,
ShutdownListener,
Container {
    private MIDPApplicationListener mListener = null;
    private boolean mStartInBackGround = false;
    private Hashtable mArgs;
    private MIDlet mMidlet;

    public void init(Hashtable args, boolean startInBackGround) {
        ApplicationUtils.getInstance().addShutdownListener(this);
        String appName = this.getAppName();
        this.mStartInBackGround = startInBackGround;
        this.mArgs = args;
    }

    public void setMidlet(Object midlet) {
        this.mMidlet = (MIDlet)midlet;
    }

    public Container getContainer() {
        return this;
    }

    public String getName() {
        return this.getAppName();
    }

    public String getAppVersion() {
        return ApplicationInfo.getInstance().getVersion();
    }

    public String getVendor() {
        return ApplicationInfo.getInstance().getVendor();
    }

    public void shuttingDown() {
        if (this.mListener != null) {
            this.mListener.stopped(this);
        }
    }

    public MIDlet getMIDlet() {
        return this.mMidlet;
    }

    public void addListener(MIDPApplicationListener aListener) {
        this.mListener = aListener;
    }

    public String getAppHome() {
        return ApplicationInfo.getInstance().getRootPath();
    }

    public Hashtable getAppProperties() {
        return this.mArgs;
    }

    public InputStream getResourceAsStream(String aResourceName) throws IOException {
        return this.getClass().getResourceAsStream(aResourceName);
    }

    public int getUID() {
        String u = null;
        try {
            u = ApplicationInfo.getInstance().getUid().getStringValue();
            return (int)Long.parseLong(u.substring(1, u.length() - 1), 16);
        }
        catch (Throwable t) {
            Logger.ELOG(2, "Error converting UID: " + u, t);
            throw new RuntimeException("UID not available");
        }
    }

    public String getAppName() {
        return ApplicationInfo.getInstance().getName();
    }

    public void pause() {
        ApplicationUtils.getInstance().pauseApplication();
    }

    public void resume() {
        ApplicationUtils.getInstance().resumeApplication();
    }

    public void shutdown() {
        ApplicationUtils.getInstance().notifyExitCmd();
    }

    public boolean startInBackground() {
        return this.mStartInBackGround;
    }
}

