/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.FloatingPointParser;
import com.ibm.oti.util.NumberConverter;

public final class Double {
    final double value;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NaN = 0.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;

    public Double(double value) {
        this.value = value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public static native long doubleToLongBits(double var0);

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Double && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Double)object).value);
    }

    public float floatValue() {
        return (float)this.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public static native double longBitsToDouble(long var0);

    public long longValue() {
        return (long)this.value;
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return FloatingPointParser.parseDouble(string);
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public static String toString(double d) {
        return NumberConverter.convert(d);
    }

    public static Double valueOf(String string) throws NumberFormatException {
        return new Double(Double.parseDouble(string));
    }
}

