/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.FloatingPointParser;
import com.ibm.oti.util.NumberConverter;

public final class Float {
    final float value;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Float && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)object).value);
    }

    public static native int floatToIntBits(float var0);

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public static native float intBitsToFloat(int var0);

    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public static boolean isNaN(float f) {
        return f != f;
    }

    public long longValue() {
        return (long)this.value;
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return FloatingPointParser.parseFloat(string);
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public static String toString(float f) {
        return NumberConverter.convert(f);
    }

    public static Float valueOf(String string) throws NumberFormatException {
        return new Float(Float.parseFloat(string));
    }
}

