/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.io.CharacterConverter;
import com.ibm.oti.io.NativeCharacterConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public final class String {
    private static final char[] ascii = new char[128];
    private final char[] value;
    private final int offset;
    private final int count;
    private int hashCode;
    private static CharacterConverter DefaultConverter;
    private static CharacterConverter lastConverter;

    static {
        int i = 0;
        while (i < ascii.length) {
            String.ascii[i] = (char)i;
            ++i;
        }
    }

    public String() {
        this.value = new char[0];
        this.offset = 0;
        this.count = 0;
    }

    private String(String s, char c) {
        this.offset = 0;
        this.value = new char[s.count + 1];
        this.count = s.count + 1;
        System.arraycopy((Object)s.value, s.offset, (Object)this.value, 0, s.count);
        this.value[s.count] = c;
    }

    public String(byte[] data) {
        this(data, 0, data.length);
    }

    public String(byte[] data, int start, int length) {
        if (start < 0 || length < 0 || length > data.length - start) {
            throw new StringIndexOutOfBoundsException();
        }
        this.offset = 0;
        CharacterConverter converter = String.defaultConverter();
        this.value = converter.convert(data, start, length);
        this.count = this.value.length;
    }

    public String(byte[] data, int start, int length, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            throw new NullPointerException();
        }
        if (start < 0 || length < 0 || length > data.length - start) {
            throw new StringIndexOutOfBoundsException();
        }
        this.offset = 0;
        CharacterConverter converter = this.getConverter(encoding);
        this.value = converter.convert(data, start, length);
        this.count = this.value.length;
    }

    public String(byte[] data, String encoding) throws UnsupportedEncodingException {
        this(data, 0, data.length, encoding);
    }

    public String(char[] data) {
        this(data, 0, data.length);
    }

    public String(char[] data, int start, int length) {
        if (start >= 0 && length >= 0 && length <= data.length - start) {
            this.offset = 0;
            this.value = new char[length];
            this.count = length;
            try {
                System.arraycopy((Object)data, start, (Object)this.value, 0, this.count);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new StringIndexOutOfBoundsException();
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    String(int start, int length, char[] data) {
        this.value = data;
        this.offset = start;
        this.count = length;
    }

    public String(String string) {
        this.value = string.value;
        this.offset = string.offset;
        this.count = string.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringbuffer) {
        this.offset = 0;
        StringBuffer stringBuffer = stringbuffer;
        synchronized (stringBuffer) {
            this.value = stringbuffer.shareValue();
            this.count = stringbuffer.length();
        }
    }

    private String(String s1, String s2) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        int len = s1.count + s2.count;
        this.value = new char[len];
        this.offset = 0;
        System.arraycopy((Object)s1.value, s1.offset, (Object)this.value, 0, s1.count);
        System.arraycopy((Object)s2.value, s2.offset, (Object)this.value, s1.count, s2.count);
        this.count = len;
    }

    private String(String s1, String s2, String s3) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        int len = s1.count + s2.count + s3.count;
        this.value = new char[len];
        this.offset = 0;
        System.arraycopy((Object)s1.value, s1.offset, (Object)this.value, 0, s1.count);
        System.arraycopy((Object)s2.value, s2.offset, (Object)this.value, s1.count, s2.count);
        System.arraycopy((Object)s3.value, s3.offset, (Object)this.value, s1.count + s2.count, s3.count);
        this.count = len;
    }

    private String(String s1, int v1) {
        int res;
        int quot;
        if (s1 == null) {
            s1 = "null";
        }
        int len2 = 1;
        int i = v1;
        while ((i /= 10) != 0) {
            ++len2;
        }
        if (v1 >= 0) {
            quot = -v1;
        } else {
            ++len2;
            quot = v1;
        }
        int len = s1.count + len2;
        this.value = new char[len];
        int index = len - 1;
        do {
            res = quot / 10;
            int rem = quot - res * 10;
            this.value[index] = (char)(48 - rem);
            --index;
        } while ((quot = res) != 0);
        if (v1 < 0) {
            this.value[index] = 45;
        }
        this.offset = 0;
        System.arraycopy((Object)s1.value, s1.offset, (Object)this.value, 0, s1.count);
        this.count = len;
    }

    public char charAt(int index) {
        if (index >= 0 && index < this.count) {
            return this.value[this.offset + index];
        }
        throw new StringIndexOutOfBoundsException();
    }

    public int compareTo(String string) {
        int o1 = this.offset;
        int o2 = string.offset;
        int end = this.offset + (this.count < string.count ? this.count : string.count);
        char[] target = string.value;
        while (o1 < end) {
            int result;
            if ((result = this.value[o1++] - target[o2++]) == 0) continue;
            return result;
        }
        return this.count - string.count;
    }

    public String concat(String string) {
        if (string.count > 0) {
            char[] buffer = new char[this.count + string.count];
            if (this.count > 0) {
                System.arraycopy((Object)this.value, this.offset, (Object)buffer, 0, this.count);
            }
            System.arraycopy((Object)string.value, string.offset, (Object)buffer, this.count, string.count);
            return new String(0, buffer.length, buffer);
        }
        return this;
    }

    private static CharacterConverter defaultConverter() {
        if (DefaultConverter == null) {
            String encoding = System.getProperty("microedition.encoding");
            if (DefaultConverter == null) {
                DefaultConverter = CharacterConverter.getDefaultConverter(encoding).getModeless();
            }
        }
        return DefaultConverter;
    }

    public boolean endsWith(String suffix) {
        return this.regionMatches(this.count - suffix.count, suffix, 0, suffix.count);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof String) {
            String s = (String)object;
            if (this.count != s.count || this.hashCode != s.hashCode && this.hashCode != 0 && s.hashCode != 0) {
                return false;
            }
            return this.regionMatches(0, s, 0, this.count);
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string == this) {
            return true;
        }
        if (string == null || this.count != string.count) {
            return false;
        }
        int o1 = this.offset;
        int o2 = string.offset;
        int end = this.offset + this.count;
        char[] target = string.value;
        while (o1 < end) {
            char c2;
            char c1;
            if ((c1 = this.value[o1++]) == (c2 = target[o2++]) || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        return String.defaultConverter().convert(this.value, this.offset, this.count);
    }

    public byte[] getBytes(String encoding) throws UnsupportedEncodingException {
        return this.getConverter(encoding).convert(this.value, this.offset, this.count);
    }

    private CharacterConverter getConverter(String encoding) throws UnsupportedEncodingException {
        Thread thread = Thread.currentThread();
        CharacterConverter converter = lastConverter;
        if (converter != null && converter.isCalled(encoding)) {
            return converter;
        }
        NativeCharacterConverter nativeConverter = thread.cachedConverter;
        if (nativeConverter != null && nativeConverter.isCalled(encoding)) {
            return nativeConverter;
        }
        converter = CharacterConverter.getConverter(encoding);
        if (converter == null) {
            throw new UnsupportedEncodingException(encoding);
        }
        if (converter instanceof NativeCharacterConverter) {
            if (nativeConverter != null) {
                nativeConverter.close();
                thread.cachedConverter = null;
            }
            thread.cachedConverter = nativeConverter = (NativeCharacterConverter)converter;
            return nativeConverter;
        }
        lastConverter = converter = converter.getModeless();
        return converter;
    }

    public void getChars(int start, int end, char[] buffer, int index) {
        if (start < 0 || start > end || end > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy((Object)this.value, start + this.offset, (Object)buffer, index, end - start);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.hashCodeImpl();
        }
        return this.hashCode;
    }

    private native int hashCodeImpl();

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public native int indexOf(int var1, int var2);

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.count) > 0) {
            if (subCount + start > this.count) {
                return -1;
            }
            char[] target = subString.value;
            int subOffset = subString.offset;
            char firstChar = target[subOffset];
            int end = subOffset + subCount;
            while (true) {
                int i;
                if ((i = this.indexOf(firstChar, start)) == -1 || subCount + i > this.count) {
                    return -1;
                }
                int o1 = this.offset + i;
                int o2 = subOffset;
                while (++o2 < end && this.value[++o1] == target[o2]) {
                }
                if (o2 == end) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < this.count ? start : this.count;
    }

    public native String intern();

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.count - 1);
    }

    public native int lastIndexOf(int var1, int var2);

    public int length() {
        return this.count;
    }

    native boolean regionMatches(int var1, String var2, int var3, int var4);

    public boolean regionMatches(boolean ignoreCase, int thisStart, String string, int start, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string, start, length);
        }
        if (string != null) {
            if (thisStart < 0 || length > this.count - thisStart) {
                return false;
            }
            if (start < 0 || length > string.count - start) {
                return false;
            }
            start += string.offset;
            int end = (thisStart += this.offset) + length;
            char[] target = string.value;
            while (thisStart < end) {
                char c2;
                char c1;
                if ((c1 = this.value[thisStart++]) == (c2 = target[start++]) || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
        throw new NullPointerException();
    }

    public String replace(char oldChar, char newChar) {
        int index = this.indexOf(oldChar, 0);
        if (index == -1) {
            return this;
        }
        char[] buffer = new char[this.count];
        System.arraycopy((Object)this.value, this.offset, (Object)buffer, 0, this.count);
        do {
            buffer[index++] = newChar;
        } while ((index = this.indexOf(oldChar, index)) != -1);
        return new String(0, this.count, buffer);
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int start) {
        return this.regionMatches(start, prefix, 0, prefix.count);
    }

    public String substring(int start) {
        if (start == 0) {
            return this;
        }
        if (start >= 0 && start <= this.count) {
            return new String(this.offset + start, this.count - start, this.value);
        }
        throw new StringIndexOutOfBoundsException(start);
    }

    public String substring(int start, int end) {
        if (start == 0 && end == this.count) {
            return this;
        }
        if (start >= 0 && start <= end && end <= this.count) {
            return new String(this.offset + start, end - start, this.value);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public char[] toCharArray() {
        char[] buffer = new char[this.count];
        System.arraycopy((Object)this.value, this.offset, (Object)buffer, 0, this.count);
        return buffer;
    }

    public String toLowerCase() {
        int o = this.offset;
        int end = this.offset + this.count;
        while (o < end) {
            char ch = this.value[o];
            if (ch != Character.toLowerCase(ch)) {
                char[] buffer = new char[this.count];
                int i = o - this.offset;
                System.arraycopy((Object)this.value, this.offset, (Object)buffer, 0, i);
                while (i < this.count) {
                    buffer[i++] = Character.toLowerCase(this.value[o++]);
                }
                return new String(0, this.count, buffer);
            }
            ++o;
        }
        return this;
    }

    public String toString() {
        return this;
    }

    public String toUpperCase() {
        int index = this.indexOf(223, 0);
        if (index >= 0) {
            int size = this.count + 1;
            while ((index = this.indexOf(223, index + 1)) != -1) {
                ++size;
            }
            char[] buffer = new char[size];
            int i = 0;
            int o = this.offset;
            int end = this.offset + this.count;
            while (o < end) {
                char ch = this.value[o];
                if (ch != '\u00df') {
                    buffer[i++] = Character.toUpperCase(ch);
                } else {
                    buffer[i++] = 83;
                    buffer[i++] = 83;
                }
                ++o;
            }
            return new String(0, size, buffer);
        }
        int o = this.offset;
        int end = this.offset + this.count;
        while (o < end) {
            char ch = this.value[o];
            if (ch != Character.toUpperCase(ch)) {
                char[] buffer = new char[this.count];
                int i = o - this.offset;
                System.arraycopy((Object)this.value, this.offset, (Object)buffer, 0, i);
                while (i < this.count) {
                    buffer[i++] = Character.toUpperCase(this.value[o++]);
                }
                return new String(0, this.count, buffer);
            }
            ++o;
        }
        return this;
    }

    public String trim() {
        int last;
        int start = this.offset;
        int end = last = this.offset + this.count - 1;
        while (start <= end && this.value[start] <= ' ') {
            ++start;
        }
        while (end >= start && this.value[end] <= ' ') {
            --end;
        }
        if (start == this.offset && end == last) {
            return this;
        }
        return new String(start, end - start + 1, this.value);
    }

    public static String valueOf(char[] data) {
        return new String(data, 0, data.length);
    }

    public static String valueOf(char[] data, int start, int length) {
        return new String(data, start, length);
    }

    public static String valueOf(char value) {
        String s = value < '\u0080' ? new String(value, 1, ascii) : new String(0, 1, new char[]{value});
        s.hashCode = value;
        return s;
    }

    public static String valueOf(double value) {
        return Double.toString(value);
    }

    public static String valueOf(float value) {
        return Float.toString(value);
    }

    public static String valueOf(int value) {
        return Integer.toString(value);
    }

    public static String valueOf(long value) {
        return Long.toString(value);
    }

    public static String valueOf(Object value) {
        return value != null ? value.toString() : "null";
    }

    public static String valueOf(boolean value) {
        return value ? "true" : "false";
    }

    char[] getValue() {
        return this.value;
    }

    static class ConsolePrintStream
    extends PrintStream {
        private static CharacterConverter converter;

        static {
            String consoleEncoding = System.getProperty("console.encoding");
            if (consoleEncoding == null) {
                consoleEncoding = "ISO8859_1";
            }
            converter = CharacterConverter.getDefaultConverter(consoleEncoding);
        }

        public ConsolePrintStream(OutputStream out) {
            super(out);
        }

        public void print(String str) {
            if (str == null) {
                str = "null";
            }
            try {
                this.write(converter.convert(str.value, str.offset, str.count));
            }
            catch (IOException iOException) {
                this.setError();
            }
        }
    }
}

