/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.connection.file.FileOutputStream;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.SystemPropertiesHook;
import java.io.PrintStream;
import java.util.Hashtable;

public final class System {
    public static final PrintStream out;
    public static final PrintStream err;
    private static final Runtime RUNTIME;
    private static Hashtable systemProperties;
    private static final int InitLocale = 0;
    private static final int PlatformEncoding = 1;
    private static final int FileEncoding = 2;
    private static final int OSEncoding = 3;

    static {
        RUNTIME = Runtime.getRuntime();
        System.ensureProperties();
        out = new String.ConsolePrintStream(FileOutputStream.out);
        err = new String.ConsolePrintStream(FileOutputStream.err);
    }

    static void completeInitialization() {
        String extraLibs = (String)systemProperties.get("com.ibm.util.extralibs.properties");
        if (extraLibs != null) {
            int lastIndex = 0;
            while (lastIndex < extraLibs.length()) {
                int index = extraLibs.indexOf(58, lastIndex);
                if (index == -1) {
                    index = extraLibs.length();
                }
                String libName = extraLibs.substring(lastIndex, index).trim();
                lastIndex = index + 1;
                if (libName.length() == 0) continue;
                try {
                    String extensionName = "com.ibm.oti." + libName + ".SystemPropertyExtension";
                    Class extensionCls = Class.forName(extensionName);
                    SystemPropertiesHook extension = (SystemPropertiesHook)extensionCls.newInstance();
                    try {
                        systemProperties = extension.extendSystemProperties(systemProperties);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void arraycopy(Object[] A1, int offset1, Object[] A2, int offset2, int length) {
        if (A1 == null || A2 == null) {
            throw new NullPointerException();
        }
        if (offset1 >= 0 && offset2 >= 0 && length >= 0 && length <= A1.length - offset1 && length <= A2.length - offset2) {
            if (A1 != A2 || offset1 > offset2 || offset1 + length <= offset2) {
                int i = 0;
                while (i < length) {
                    A2[offset2 + i] = A1[offset1 + i];
                    ++i;
                }
            } else {
                int i = length - 1;
                while (i >= 0) {
                    A2[offset2 + i] = A1[offset1 + i];
                    --i;
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static native long currentTimeMillis();

    private static void ensureProperties() {
        String fileEncoding;
        systemProperties = new Hashtable(101);
        String platformEncoding = null;
        String osEncoding = null;
        String definedFileEncoding = System.getEncoding(2);
        String definedOSEncoding = System.getEncoding(3);
        if (definedFileEncoding != null) {
            fileEncoding = definedFileEncoding;
            if (definedOSEncoding == null) {
                osEncoding = platformEncoding = System.getEncoding(1);
            } else {
                System.getEncoding(0);
            }
        } else {
            fileEncoding = platformEncoding = System.getEncoding(1);
        }
        if (osEncoding == null) {
            osEncoding = definedOSEncoding;
        }
        if (osEncoding != null) {
            systemProperties.put("os.encoding", osEncoding);
        }
        systemProperties.put("microedition.encoding", fileEncoding);
        systemProperties.put("microedition.configuration", "CLDC-1.1");
        systemProperties.put("microedition.profiles", "");
        systemProperties.put("com.ibm.oti.configuration", "cldc11");
        systemProperties.put("com.ibm.oti.configuration.dir", "jclCldc11");
        String[] list = System.getPropertyList();
        int i = 0;
        while (i < list.length) {
            String key = list[i];
            if (key == null) break;
            systemProperties.put(key, list[i + 1]);
            i += 2;
        }
        String consoleEncoding = (String)systemProperties.get("console.encoding");
        if (consoleEncoding == null) {
            if (platformEncoding == null) {
                platformEncoding = System.getEncoding(1);
            }
            consoleEncoding = platformEncoding;
            systemProperties.put("console.encoding", consoleEncoding);
        }
        if (systemProperties.get("microedition.platform") == null) {
            systemProperties.put("microedition.platform", systemProperties.get("os.name"));
        }
        systemProperties.put("com.ibm.oti.jcl.build", "20090831_0954");
    }

    public static void exit(int code) {
        RUNTIME.exit(code);
    }

    public static void gc() {
        RUNTIME.gc();
    }

    public static String getProperty(String prop) {
        if (!prop.equals("")) {
            String result = (String)systemProperties.get(prop);
            return result;
        }
        throw new IllegalArgumentException(Msg.getString("K00de"));
    }

    static String setProperty(String prop, String value) {
        return (String)systemProperties.put(prop, value);
    }

    private static native String[] getPropertyList();

    private static native String getEncoding(int var0);

    public static native int identityHashCode(Object var0);
}

