/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Hashtable {
    transient int elementCount;
    transient Entry[] elementData;
    private int threshold;
    transient int firstSlot = 0;
    transient int lastSlot = -1;
    private static final Enumeration emptyEnumerator = new Hashtable(0).getEmptyEnumerator();

    private static Entry newEntry(Object key, Object value, int hash) {
        return new Entry(key, value);
    }

    public Hashtable() {
        this(11);
    }

    public Hashtable(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = new Entry[capacity == 0 ? 1 : capacity];
        this.firstSlot = this.elementData.length;
        this.computeMaxSize();
    }

    private HashEnumerator getEmptyEnumerator() {
        return new HashEnumerator(false);
    }

    public synchronized void clear() {
        this.elementCount = 0;
        int i = this.elementData.length;
        while (--i >= 0) {
            this.elementData[i] = null;
        }
    }

    private void computeMaxSize() {
        this.threshold = this.elementData.length / 4 * 3 + this.elementData.length % 4 * 3 / 4;
    }

    public synchronized boolean contains(Object value) {
        if (value != null) {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry entry = this.elementData[i];
                while (entry != null) {
                    if (value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
            return false;
        }
        throw new NullPointerException();
    }

    public synchronized boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public synchronized Enumeration elements() {
        if (this.elementCount == 0) {
            return emptyEnumerator;
        }
        return new HashEnumerator(false);
    }

    public synchronized Object get(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry entry = this.elementData[index];
        while (entry != null) {
            if (entry.equalsKey(key, hash)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry getEntry(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry entry = this.elementData[index];
        while (entry != null) {
            if (entry.equalsKey(key, hash)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Enumeration keys() {
        if (this.elementCount == 0) {
            return emptyEnumerator;
        }
        return new HashEnumerator(true);
    }

    public synchronized Object put(Object key, Object value) {
        if (key != null && value != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            Entry entry = this.elementData[index];
            while (entry != null && !entry.equalsKey(key, hash)) {
                entry = entry.next;
            }
            if (entry == null) {
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    index = (hash & Integer.MAX_VALUE) % this.elementData.length;
                }
                if (index < this.firstSlot) {
                    this.firstSlot = index;
                }
                if (index > this.lastSlot) {
                    this.lastSlot = index;
                }
                entry = Hashtable.newEntry(key, value, hash);
                entry.next = this.elementData[index];
                this.elementData[index] = entry;
                return null;
            }
            Object result = entry.value;
            entry.value = value;
            return result;
        }
        throw new NullPointerException();
    }

    protected void rehash() {
        int length = (this.elementData.length << 1) + 1;
        if (length == 0) {
            length = 1;
        }
        int newFirst = length;
        int newLast = -1;
        Entry[] newData = new Entry[length];
        int i = this.lastSlot + 1;
        while (--i >= this.firstSlot) {
            Entry entry = this.elementData[i];
            while (entry != null) {
                int index = (entry.getKeyHash() & Integer.MAX_VALUE) % length;
                if (index < newFirst) {
                    newFirst = index;
                }
                if (index > newLast) {
                    newLast = index;
                }
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.firstSlot = newFirst;
        this.lastSlot = newLast;
        this.elementData = newData;
        this.computeMaxSize();
    }

    public synchronized Object remove(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry last = null;
        Entry entry = this.elementData[index];
        while (entry != null && !entry.equalsKey(key, hash)) {
            last = entry;
            entry = entry.next;
        }
        if (entry != null) {
            if (last == null) {
                this.elementData[index] = entry.next;
            } else {
                last.next = entry.next;
            }
            --this.elementCount;
            Object result = entry.value;
            entry.value = null;
            return result;
        }
        return null;
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer(this.size() * 28);
        buffer.append('{');
        int i = this.lastSlot;
        while (i >= this.firstSlot) {
            Entry entry = this.elementData[i];
            while (entry != null) {
                if (entry.key != this) {
                    buffer.append(entry.key);
                } else {
                    buffer.append("(this Map)");
                }
                buffer.append('=');
                if (entry.value != this) {
                    buffer.append(entry.value);
                } else {
                    buffer.append("(this Map)");
                }
                buffer.append(", ");
                entry = entry.next;
            }
            --i;
        }
        if (this.elementCount > 0) {
            buffer.setLength(buffer.length() - 2);
        }
        buffer.append('}');
        return buffer.toString();
    }

    private static final class Entry {
        private Object key;
        private Object value;
        Entry next;

        Entry(Object theKey, Object theValue) {
            this.key = theKey;
            this.value = theValue;
        }

        public int getKeyHash() {
            return this.key.hashCode();
        }

        public boolean equalsKey(Object aKey, int hash) {
            return this.key.equals(aKey);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private final class HashEnumerator
    implements Enumeration {
        boolean key;
        int start;
        Entry entry;

        HashEnumerator(boolean isKey) {
            this.key = isKey;
            this.start = Hashtable.this.lastSlot + 1;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.entry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                if (Hashtable.this.elementData[--this.start] == null) continue;
                this.entry = Hashtable.this.elementData[this.start];
                return true;
lbl6:
                // 2 sources

                ** while (this.start > Hashtable.this.firstSlot)
            }
lbl7:
            // 1 sources

            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                Object result = this.key ? this.entry.key : this.entry.value;
                this.entry = this.entry.next;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

