/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import javax.microedition.location.Coordinates;

public class QualifiedCoordinates
extends Coordinates {
    private static final String ILLEGAL_ACCURACY_VALUE = "Illegal accuracy value: ";
    private float iHorizontalAccuracy = Float.NaN;
    private float iVerticalAccuracy = Float.NaN;

    public QualifiedCoordinates(double aLatitude, double aLongitude, float aAltitude, float aHorizontalAccuracy, float aVerticalAccuracy) {
        super(aLatitude, aLongitude, aAltitude);
        this.setHorizontalAccuracy(aHorizontalAccuracy);
        this.setVerticalAccuracy(aVerticalAccuracy);
    }

    public float getHorizontalAccuracy() {
        return this.iHorizontalAccuracy;
    }

    public float getVerticalAccuracy() {
        return this.iVerticalAccuracy;
    }

    public void setHorizontalAccuracy(float aHorizontalAccuracy) {
        this.checkValue(aHorizontalAccuracy);
        this.iHorizontalAccuracy = aHorizontalAccuracy;
    }

    public void setVerticalAccuracy(float aVerticalAccuracy) {
        this.checkValue(aVerticalAccuracy);
        this.iVerticalAccuracy = aVerticalAccuracy;
    }

    private void checkValue(float aValue) {
        if (!Float.isNaN(aValue) && aValue < 0.0f) {
            throw new IllegalArgumentException(ILLEGAL_ACCURACY_VALUE + aValue);
        }
    }
}

