/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

final class RecordEnumerationImpl
implements RecordEnumeration,
RecordListener {
    private RecordStore iRecordStore;
    private RecordFilter iRecordFilter;
    private RecordComparator iRecordComparator;
    private boolean iKeepUpdated;
    private int[] iRecordIDs;
    private int iCurrentPos;
    private static final int POS_AFTER_RESET = -1;

    public RecordEnumerationImpl(RecordStore aRecStore, RecordFilter aFilter, RecordComparator aComparator, boolean aKeepUpdated) {
        this.iRecordStore = aRecStore;
        this.iRecordFilter = aFilter;
        this.iRecordComparator = aComparator;
        this.keepUpdated(aKeepUpdated);
        this.reset();
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numRecords() {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            return this.iRecordIDs.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] nextRecord() throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            int recID = this.nextRecordId();
            return this.iRecordStore.getRecord(recID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextRecordId() throws InvalidRecordIDException {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            ++this.iCurrentPos;
            if (this.iCurrentPos >= this.iRecordIDs.length) {
                throw new InvalidRecordIDException("Next/previous record not found");
            }
            return this.iRecordIDs[this.iCurrentPos];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] previousRecord() throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            int recID = this.previousRecordId();
            return this.iRecordStore.getRecord(recID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int previousRecordId() throws InvalidRecordIDException {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            if (this.iCurrentPos == 0 || this.iRecordIDs.length == 0) {
                throw new InvalidRecordIDException("Next/previous record not found");
            }
            this.iCurrentPos = this.iCurrentPos == -1 ? this.iRecordIDs.length - 1 : --this.iCurrentPos;
            return this.iRecordIDs[this.iCurrentPos];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextElement() {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            return this.iCurrentPos < this.iRecordIDs.length - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPreviousElement() {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            return this.iRecordIDs.length != 0 && this.iCurrentPos != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            this.iCurrentPos = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            this.iRecordIDs = this.iRecordStore.getRecordIDs();
            if (this.iRecordFilter != null) {
                this.doFilter();
            }
            if (this.iRecordComparator != null) {
                this.doSort();
            }
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepUpdated(boolean aKeepUpdated) {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            this.iKeepUpdated = aKeepUpdated;
            if (this.iKeepUpdated) {
                this.rebuild();
                this.iRecordStore.addRecordListener(this);
            } else {
                this.iRecordStore.removeRecordListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeptUpdated() {
        Object object = this.ensureNotDestroyed();
        synchronized (object) {
            return this.iKeepUpdated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        RecordEnumerationImpl recordEnumerationImpl = this;
        synchronized (recordEnumerationImpl) {
            Object object = this.ensureNotDestroyed();
            synchronized (object) {
                this.keepUpdated(false);
                this.iRecordStore = null;
                this.iRecordFilter = null;
                this.iRecordComparator = null;
                this.iRecordIDs = null;
            }
        }
    }

    public void recordAdded(RecordStore aRecordStore, int aRecordId) {
        try {
            byte[] newRecord = this.iRecordStore.getRecord(aRecordId);
            if (this.iRecordFilter != null && !this.iRecordFilter.matches(newRecord)) {
                return;
            }
            int[] updatedIDs = new int[this.iRecordIDs.length + 1];
            updatedIDs[updatedIDs.length - 1] = aRecordId;
            if (this.iRecordComparator != null) {
                int i = 0;
                for (i = 0; i < this.iRecordIDs.length; ++i) {
                    if (this.iRecordComparator.compare(this.iRecordStore.getRecord(this.iRecordIDs[i]), newRecord) != -1) {
                        updatedIDs[i] = aRecordId;
                        System.arraycopy((Object)this.iRecordIDs, i, (Object)updatedIDs, i + 1, this.iRecordIDs.length - i);
                        break;
                    }
                    updatedIDs[i] = this.iRecordIDs[i];
                }
                if (this.iCurrentPos != -1 && i <= this.iCurrentPos) {
                    ++this.iCurrentPos;
                }
            } else {
                System.arraycopy((Object)this.iRecordIDs, 0, (Object)updatedIDs, 0, this.iRecordIDs.length);
                updatedIDs[this.iRecordIDs.length] = aRecordId;
            }
            this.iRecordIDs = updatedIDs;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void recordChanged(RecordStore aRecordStore, int aRecordId) {
        this.recordDeleted(aRecordStore, aRecordId);
        this.recordAdded(aRecordStore, aRecordId);
    }

    public void recordDeleted(RecordStore aRecordStore, int aRecordId) {
        for (int i = 0; i < this.iRecordIDs.length; ++i) {
            if (aRecordId != this.iRecordIDs[i]) continue;
            int[] updatedIDs = new int[this.iRecordIDs.length - 1];
            System.arraycopy((Object)this.iRecordIDs, 0, (Object)updatedIDs, 0, i);
            System.arraycopy((Object)this.iRecordIDs, i + 1, (Object)updatedIDs, i, this.iRecordIDs.length - i - 1);
            if (this.iCurrentPos == updatedIDs.length || i <= this.iCurrentPos) {
                --this.iCurrentPos;
            }
            this.iRecordIDs = updatedIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object ensureNotDestroyed() {
        RecordEnumerationImpl recordEnumerationImpl = this;
        synchronized (recordEnumerationImpl) {
            if (this.iRecordStore == null) {
                throw new IllegalStateException("RecordEnumeration is not usable after destroy() has been called");
            }
            return this.iRecordStore.iRsSync;
        }
    }

    private void doFilter() {
        try {
            Vector filtered = new Vector();
            for (int i = 0; i < this.iRecordIDs.length; ++i) {
                byte[] record = this.iRecordStore.getRecord(this.iRecordIDs[i]);
                if (!this.iRecordFilter.matches(record)) continue;
                filtered.addElement(new Integer(this.iRecordIDs[i]));
            }
            int[] filteredIDs = new int[filtered.size()];
            for (int j = 0; j < filteredIDs.length; ++j) {
                Integer id = (Integer)filtered.elementAt(j);
                filteredIDs[j] = id;
            }
            this.iRecordIDs = filteredIDs;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void doSort() {
        try {
            this.quicksort(this.iRecordIDs, 0, this.iRecordIDs.length - 1);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void quicksort(int[] array, int aLeft, int aRight) throws RecordStoreException {
        if (aLeft >= aRight) {
            return;
        }
        int i = aLeft + 1;
        int j = aRight;
        byte[] pivot = this.iRecordStore.getRecord(this.iRecordIDs[aLeft]);
        while (i <= j) {
            if (this.iRecordComparator.compare(pivot, this.iRecordStore.getRecord(array[i])) == 1) {
                ++i;
                continue;
            }
            if (this.iRecordComparator.compare(this.iRecordStore.getRecord(array[j]), pivot) == 1) {
                --j;
                continue;
            }
            this.swap(array, i, j);
        }
        this.swap(array, aLeft, j);
        this.quicksort(array, aLeft, j - 1);
        this.quicksort(array, j + 1, aRight);
    }

    private void swap(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}

