/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.sensor;

import javax.microedition.sensor.Condition;

public final class LimitCondition
implements Condition {
    private final double limit;
    private final int intOp;
    private final String op;
    private static final int INT_EQUALS = 1;
    private static final int INT_GREATER_THAN = 16;
    private static final int INT_GREATER_THAN_OR_EQUALS = 32;
    private static final int INT_LESS_THAN = 2;
    private static final int INT_LESS_THAN_OR_EQUALS = 4;
    private static final int INT_ALL_EQUALS = 37;
    private static final int INT_ALL_GREATER_THAN = 48;
    private static final int INT_ALL_LESS_THAN = 6;

    public LimitCondition(double limit, String operator) {
        if (operator == null) {
            throw new NullPointerException();
        }
        this.intOp = this.getIntOp(operator);
        if (this.intOp == 0) {
            throw new IllegalArgumentException();
        }
        this.limit = limit;
        this.op = operator;
    }

    public final double getLimit() {
        return this.limit;
    }

    public final String getOperator() {
        return this.op;
    }

    public boolean isMet(double value) {
        if ((this.intOp & 0x25) > 0 && Double.doubleToLongBits(this.limit) == Double.doubleToLongBits(value)) {
            return true;
        }
        if ((this.intOp & 0x30) > 0 && value > this.limit) {
            return true;
        }
        return (this.intOp & 6) > 0 && value < this.limit;
    }

    public boolean isMet(Object value) {
        return false;
    }

    private int getIntOp(String op) {
        if (op.equals("eq")) {
            return 1;
        }
        if (op.equals("lt")) {
            return 2;
        }
        if (op.equals("le")) {
            return 4;
        }
        if (op.equals("gt")) {
            return 16;
        }
        if (op.equals("ge")) {
            return 32;
        }
        return 0;
    }
}

