/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private String fName;

    public TestCase() {
        this.fName = null;
    }

    public TestCase(String string) {
        this.fName = string;
    }

    public int countTestCases() {
        return 1;
    }

    protected TestResult createResult() {
        return new TestResult();
    }

    public TestResult run() {
        TestResult testResult = this.createResult();
        this.run(testResult);
        return testResult;
    }

    public void run(TestResult testResult) {
        testResult.run(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runBare() throws Throwable {
        this.setUp();
        try {
            this.runTest();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.tearDown();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.tearDown();
    }

    protected void runTest() throws Throwable {
        TestCase.assertNotNull(this.fName);
        Method method = null;
        try {
            method = this.getClass().getMethod(this.fName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            TestCase.fail("Method \"" + this.fName + "\" not found");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            TestCase.fail("Method \"" + this.fName + "\" should be public");
        }
        try {
            method.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.fillInStackTrace();
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.fillInStackTrace();
            throw illegalAccessException;
        }
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.getClass().getName() + ")";
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        this.fName = string;
    }
}

