/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;

public class ResultPrinter
implements TestListener {
    PrintStream fWriter;
    int fColumn = 0;

    public ResultPrinter(PrintStream printStream) {
        this.fWriter = printStream;
    }

    synchronized void print(TestResult testResult, long l) {
        this.printHeader(l);
        this.printErrors(testResult);
        this.printFailures(testResult);
        this.printFooter(testResult);
    }

    void printWaitPrompt() {
        this.getWriter().println();
        this.getWriter().println("<RETURN> to continue");
    }

    protected void printHeader(long l) {
        this.getWriter().println();
        this.getWriter().println("Time: " + this.elapsedTimeAsString(l));
    }

    protected void printErrors(TestResult testResult) {
        this.printDefects(testResult.errors(), testResult.errorCount(), "error");
    }

    protected void printFailures(TestResult testResult) {
        this.printDefects(testResult.failures(), testResult.failureCount(), "failure");
    }

    protected void printDefects(Enumeration enumeration, int n, String string) {
        if (n == 0) {
            return;
        }
        if (n == 1) {
            this.getWriter().println("There was " + n + " " + string + ":");
        } else {
            this.getWriter().println("There were " + n + " " + string + "s:");
        }
        int n2 = 1;
        while (enumeration.hasMoreElements()) {
            this.printDefect((TestFailure)enumeration.nextElement(), n2);
            ++n2;
        }
    }

    public void printDefect(TestFailure testFailure, int n) {
        this.printDefectHeader(testFailure, n);
        this.printDefectTrace(testFailure);
    }

    protected void printDefectHeader(TestFailure testFailure, int n) {
        this.getWriter().print(String.valueOf(n) + ") " + testFailure.failedTest());
    }

    protected void printDefectTrace(TestFailure testFailure) {
        this.getWriter().print(BaseTestRunner.getFilteredTrace(testFailure.trace()));
    }

    protected void printFooter(TestResult testResult) {
        if (testResult.wasSuccessful()) {
            this.getWriter().println();
            this.getWriter().print("OK");
            this.getWriter().println(" (" + testResult.runCount() + " test" + (testResult.runCount() == 1 ? "" : "s") + ")");
        } else {
            this.getWriter().println();
            this.getWriter().println("FAILURES!!!");
            this.getWriter().println("Tests run: " + testResult.runCount() + ",  Failures: " + testResult.failureCount() + ",  Errors: " + testResult.errorCount());
        }
        this.getWriter().println();
    }

    protected String elapsedTimeAsString(long l) {
        return NumberFormat.getInstance().format((double)l / 1000.0);
    }

    public PrintStream getWriter() {
        return this.fWriter;
    }

    public void addError(Test test, Throwable throwable) {
        this.getWriter().print("E");
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.getWriter().print("F");
    }

    public void endTest(Test test) {
    }

    public void startTest(Test test) {
        this.getWriter().print(".");
        if (this.fColumn++ >= 40) {
            this.getWriter().println();
            this.fColumn = 0;
        }
    }
}

