/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.datagram;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.datagram.DatagramPacket;
import com.ibm.oti.connection.socket.Socket;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;

public class Connection
extends Socket
implements CreateConnection,
DatagramConnection {
    static final int DEFAULT_TIMEOUT = 8000;
    private String server;
    private boolean closed = false;
    private int access;
    private int port;
    private int timeout = 0;
    private int udpLocalPort;
    private byte[] localAddress = new byte[4];

    public Connection() {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.socketClose();
    }

    public int getMaximumLength() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.maxDatagramImpl();
    }

    public int getNominalLength() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.nominalDatagramImpl();
    }

    public Datagram newDatagram(byte[] data, int length) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (length < 0 || this.isOverMaxLength(length)) {
            throw new IllegalArgumentException();
        }
        DatagramPacket datagram = new DatagramPacket();
        datagram.setData(data, 0, length);
        if (this.server != null) {
            datagram.setAddress("datagram://" + this.server + ":" + this.port);
        }
        return datagram;
    }

    public Datagram newDatagram(byte[] data, int length, String address) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (length < 0 || this.isOverMaxLength(length)) {
            throw new IllegalArgumentException();
        }
        DatagramPacket datagram = new DatagramPacket();
        datagram.setData(data, 0, length);
        datagram.setAddress(address);
        return datagram;
    }

    public Datagram newDatagram(int length) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (length < 0 || this.isOverMaxLength(length)) {
            throw new IllegalArgumentException();
        }
        return this.newDatagram(new byte[length], length);
    }

    public Datagram newDatagram(int length, String address) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (length < 0 || this.isOverMaxLength(length)) {
            throw new IllegalArgumentException();
        }
        DatagramPacket datagram = new DatagramPacket();
        datagram.setData(new byte[length], 0, length);
        datagram.setAddress(address);
        return datagram;
    }

    private boolean isOverMaxLength(int length) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Datagram datagram) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 1 && this.access != 3) {
            throw new IOException(Msg.getString("K00a9"));
        }
        Connection connection = this;
        synchronized (connection) {
            int orgLength = datagram.getLength();
            datagram.setLength(this.receiveDatagramImpl(datagram.getData(), datagram.getOffset(), orgLength, this.timeout));
            String host = Socket.getHostByAddr(this.address);
            if (host == null) {
                host = Socket.addressToString(this.address);
            }
            datagram.setAddress("datagram://" + host + ":" + this.localport);
        }
    }

    native int receiveDatagramImpl(byte[] var1, int var2, int var3, int var4) throws IOException;

    public void send(Datagram datagram) throws IOException {
        String host;
        int port;
        DatagramPacket data;
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 2 && this.access != 3) {
            throw new IOException(Msg.getString("K00aa"));
        }
        if (datagram instanceof DatagramPacket) {
            data = (DatagramPacket)datagram;
        } else {
            data = new DatagramPacket();
            data.setData(datagram.getData(), datagram.getOffset(), datagram.getLength());
            data.setAddress(datagram.getAddress());
        }
        String serverAddress = data.getAddress();
        if (serverAddress == null) {
            if (this.server == null) {
                return;
            }
            port = this.port;
            host = this.server;
        } else {
            port = data.port;
            host = data.getHost();
        }
        byte[] address = Socket.resolveHost(host);
        this.sendDatagramImpl(data.getData(), data.getOffset(), data.getLength(), address, port);
    }

    private boolean isMulticastAddress(byte[] addr) {
        return (addr[0] & 0xFF) >>> 4 == 14;
    }

    native void sendDatagramImpl(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IOException;

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
        return this;
    }

    private void setParameters(String spec, String[][] equates, int access, boolean throwTimeout) throws IOException {
        this.access = access;
        int rcvbuf = 0;
        int sndbuf = 0;
        int[] result = new int[1];
        int i = 0;
        while (i < equates.length) {
            String key = equates[i][0];
            equates[i][0] = equates[i][0].toLowerCase();
            if (ConnectionUtil.intParam("so_timeout", equates[i], 1, result)) {
                this.timeout = result[0];
            } else if (ConnectionUtil.intParam("so_rcvbuf", equates[i], 2, result)) {
                rcvbuf = result[0];
            } else if (ConnectionUtil.intParam("so_sndbuf", equates[i], 2, result)) {
                sndbuf = result[0];
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", key));
            }
            ++i;
        }
        if (throwTimeout && this.timeout == 0) {
            this.timeout = 8000;
        }
        if (!spec.startsWith("//")) {
            throw new IllegalArgumentException(Msg.getString("K00a1"));
        }
        String host = Socket.parseURL(spec, result, true, true);
        if (host.length() != 0) {
            this.server = host;
        }
        this.port = result[0];
        try {
            this.bindDatagramImpl(this.server == null ? this.port : 0);
            this.localAddress = this.address;
            this.udpLocalPort = this.localport;
            if (rcvbuf != 0) {
                this.setSocketOptionImpl(4098, rcvbuf);
            }
            if (sndbuf != 0) {
                this.setSocketOptionImpl(4097, sndbuf);
            }
        }
        catch (IOException e) {
            this.socketClose();
            throw e;
        }
        this.socketOpen();
    }

    native void bindDatagramImpl(int var1) throws IOException;

    native int maxDatagramImpl();

    native int nominalDatagramImpl();
}

