/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.socket;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Socket {
    private long descriptor = -1L;
    protected int localport;
    protected byte[] address = new byte[4];
    private static Hashtable openSockets = new Hashtable(15);
    public static final int SO_LINGER = 128;
    public static final int SO_TIMEOUT = 4102;
    public static final int TCP_NODELAY = 1;
    public static final int SO_REUSEADDR = 4;
    public static final int SO_SNDBUF = 4097;
    public static final int SO_RCVBUF = 4098;
    public static final int SO_KEEPALIVE = 8;
    public static final int FLAG_BROKEN_TCP_NODELAY = 4;
    public static final int FLAG_BROKEN_SO_LINGER_SHUTDOWN = 8;
    public static final int LOOPBACK = 2130706433;

    static {
        VM.closeSockets();
    }

    private native void socketCloseImpl();

    public native void setSocketOptionImpl(int var1, int var2) throws IOException;

    public native int getSocketOptionImpl(int var1) throws IOException;

    public static native int getSocketFlags();

    public static byte[] getHostByName(String name) throws IOException {
        return Socket.getHostByNameImpl(name);
    }

    private static native byte[] getHostByNameImpl(String var0) throws IOException;

    public static native int getIPImpl(String var0);

    public static byte[] resolveHost(String host) throws IOException {
        int ch = 0;
        int index = host.lastIndexOf(46);
        boolean isIPv6 = false;
        if (index != -1 && index + 1 < host.length()) {
            ch = host.charAt(index + 1);
        }
        if (ch >= 48 && ch <= 57) {
            try {
                byte[] addr = new byte[4];
                Socket.intToBytes(Socket.getIPImpl(host), addr, 0);
                return addr;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(Msg.getString("K01cd", host));
            }
        }
        if (isIPv6) {
            throw new IllegalArgumentException(Msg.getString("K01cd", host));
        }
        if (!Socket.isValidHost(host)) {
            throw new IllegalArgumentException(Msg.getString("K01cd", host));
        }
        try {
            return Socket.getHostByNameImpl(host);
        }
        catch (IOException e) {
            if (host.equals("localhost")) {
                byte[] addr = new byte[4];
                Socket.intToBytes(2130706433, addr, 0);
                return addr;
            }
            throw e;
        }
    }

    private static boolean isValidHost(String host) {
        int lastChar = 0;
        boolean hasName = false;
        boolean beginLabel = true;
        boolean notAlpha = false;
        int i = 0;
        while (i < host.length()) {
            char current = host.charAt(i);
            if (current == '.') {
                if (beginLabel) {
                    return false;
                }
                if (lastChar == 45) {
                    return false;
                }
                beginLabel = true;
            } else if (current >= '0' && current <= '9') {
                if (beginLabel) {
                    notAlpha = true;
                }
                beginLabel = false;
            } else if (current == '-') {
                if (beginLabel) {
                    return false;
                }
                beginLabel = false;
            } else if (current >= 'A' && current <= 'Z' || current >= 'a' && current <= 'z') {
                hasName = true;
                if (beginLabel) {
                    notAlpha = false;
                }
                beginLabel = false;
            } else {
                return false;
            }
            lastChar = current;
            ++i;
        }
        return lastChar != 45 && hasName && !notAlpha;
    }

    public static String getHostByAddr(byte[] address) {
        String host = Socket.getHostByAddrImpl(address);
        return host;
    }

    private static native String getHostByAddrImpl(byte[] var0);

    public static String parseURL(String spec, int[] returnPort, boolean portRequired, boolean allowNoPort) {
        int port;
        if (spec.startsWith("//")) {
            spec = spec.substring(2);
        }
        int index = spec.lastIndexOf(58);
        int endOfIPv6Addr = spec.lastIndexOf(93);
        if (index == -1 || index < endOfIPv6Addr) {
            if (portRequired) {
                throw new IllegalArgumentException(Msg.getString("K00a6"));
            }
            return spec;
        }
        if (-1 != spec.indexOf(47) || -1 != spec.indexOf(64) || index != spec.indexOf(58) || -1 != spec.indexOf(63) || -1 != spec.indexOf(59)) {
            throw new IllegalArgumentException(Msg.getString("K039d"));
        }
        String portString = spec.substring(index + 1, spec.length());
        if (allowNoPort && portString.equals("")) {
            port = 0;
        } else {
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Msg.getString("K00a7", portString));
            }
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException(Msg.getString("K0325", port));
        }
        returnPort[0] = port;
        return spec.substring(0, index);
    }

    public void socketOpen() {
        openSockets.put(this, this);
    }

    public void socketClose() {
        this.socketCloseImpl();
        openSockets.remove(this);
    }

    public static void closeOpenSockets() {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        Enumeration keysEnum = openSockets.keys();
        while (keysEnum.hasMoreElements()) {
            Socket socket = (Socket)keysEnum.nextElement();
            socket.socketCloseImpl();
        }
    }

    public static String addressToString(byte[] value) {
        return String.valueOf(value[0] & 0xFF) + "." + (value[1] & 0xFF) + "." + (value[2] & 0xFF) + "." + (value[3] & 0xFF);
    }

    public static int socketCount() {
        return openSockets.size();
    }

    static void intToBytes(int value, byte[] bytes, int start) {
        bytes[start] = (byte)(value >> 24 & 0xFF);
        bytes[start + 1] = (byte)(value >> 16 & 0xFF);
        bytes[start + 2] = (byte)(value >> 8 & 0xFF);
        bytes[start + 3] = (byte)(value & 0xFF);
    }
}

