/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.comm;

import com.nokia.mj.impl.comm.CommConnectionPort;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;

public final class CommConnectionUrlParser {
    private static final String PORT_IR = "IR";
    private static final String PORT_USB = "USB";
    private static final String PORT_COM = "COM";
    private static final String PORT_BT = "BT";
    private static final String COMM_OPTION_BAUD_RATE = "baudrate";
    private static final String COMM_OPTION_PARITY = "parity";
    private static final String COMM_OPTION_BITSPERCHAR = "bitsperchar";
    private static final String COMM_OPTION_STOPBITS = "stopbits";
    private static final String COMM_OPTION_BLOCKING = "blocking";
    private static final String COMM_OPTION_AUTOCTS = "autocts";
    private static final String COMM_OPTION_AUTORTS = "autorts";
    private static String iFullUrl = null;

    public static Vector splitString(String aUri, char aDelimiter) {
        Vector result = new Vector();
        int currIndx = 0;
        int prevIndex = 0;
        while ((currIndx = aUri.indexOf(aDelimiter, prevIndex)) != -1) {
            result.addElement(aUri.substring(prevIndex, currIndx));
            prevIndex = currIndx;
            ++prevIndex;
        }
        if (prevIndex < aUri.length()) {
            result.addElement(aUri.substring(prevIndex, aUri.length()));
        }
        return result;
    }

    public static void setDefaultOptions(Hashtable aValidOptions) {
        aValidOptions.put(COMM_OPTION_BAUD_RATE, "-1");
        aValidOptions.put(COMM_OPTION_BITSPERCHAR, "8");
        aValidOptions.put(COMM_OPTION_STOPBITS, "1");
        aValidOptions.put(COMM_OPTION_PARITY, "none");
        aValidOptions.put(COMM_OPTION_BLOCKING, "on");
        aValidOptions.put(COMM_OPTION_AUTORTS, "on");
        aValidOptions.put(COMM_OPTION_AUTOCTS, "on");
    }

    public static void parseURI(String aUri, int[] aParamterValues, CommConnectionPort aCommPort) throws IOException {
        Hashtable validOptions = new Hashtable();
        iFullUrl = "comm:" + aUri;
        CommConnectionUrlParser.setDefaultOptions(validOptions);
        Vector result = CommConnectionUrlParser.splitString(aUri, ';');
        int n = result.size();
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid URL: " + iFullUrl);
        }
        CommConnectionUrlParser.mapPortNumber(aCommPort, (String)result.elementAt(0));
        if (n <= 1) {
            aParamterValues[0] = -1;
            aParamterValues[1] = 8;
            aParamterValues[2] = 1;
            aParamterValues[3] = 0;
            aParamterValues[4] = 1;
            aParamterValues[5] = 1;
            aParamterValues[6] = 1;
            return;
        }
        int indexOfequal = -1;
        for (int i = 1; i < n; ++i) {
            String option = (String)result.elementAt(i);
            indexOfequal = option.indexOf("=");
            if (indexOfequal == -1) {
                throw new IllegalArgumentException("Invalid URL: " + iFullUrl);
            }
            String name = option.substring(0, indexOfequal);
            if (indexOfequal + 1 >= option.length()) {
                throw new IllegalArgumentException("Invalid URL: " + iFullUrl);
            }
            String value = option.substring(indexOfequal + 1, option.length());
            if (!validOptions.containsKey(name)) {
                throw new IllegalArgumentException("Invalid URL: " + iFullUrl);
            }
            validOptions.put(name, value);
        }
        aParamterValues[0] = CommConnectionUrlParser.getIntValue((String)validOptions.get(COMM_OPTION_BAUD_RATE));
        aParamterValues[1] = CommConnectionUrlParser.getIntValue((String)validOptions.get(COMM_OPTION_BITSPERCHAR));
        aParamterValues[2] = CommConnectionUrlParser.getIntValue((String)validOptions.get(COMM_OPTION_STOPBITS));
        String parity = (String)validOptions.get(COMM_OPTION_PARITY);
        if (parity.compareTo("none") == 0) {
            aParamterValues[3] = 0;
        } else if (parity.compareTo("odd") == 0) {
            aParamterValues[3] = 1;
        } else if (parity.compareTo("even") == 0) {
            aParamterValues[3] = 2;
        } else {
            throw new IllegalArgumentException("Invalid URL: " + iFullUrl);
        }
        aParamterValues[4] = CommConnectionUrlParser.mapFlagToInteger((String)validOptions.get(COMM_OPTION_BLOCKING));
        aParamterValues[5] = CommConnectionUrlParser.mapFlagToInteger((String)validOptions.get(COMM_OPTION_AUTORTS));
        aParamterValues[6] = CommConnectionUrlParser.mapFlagToInteger((String)validOptions.get(COMM_OPTION_AUTOCTS));
    }

    private static int mapFlagToInteger(String aValue) {
        if (aValue.compareTo("off") == 0) {
            return 0;
        }
        if (aValue.compareTo("on") == 0) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid URL: " + iFullUrl);
    }

    private static void mapPortNumber(CommConnectionPort aCommPort, String aPortIdAndNumber) throws IOException {
        String tmp = aPortIdAndNumber;
        String portIdAndNumber = aPortIdAndNumber.toUpperCase();
        Logger.LOG(14, 1, "++mapPortNumber(), aPortIdAndNumber = " + aPortIdAndNumber);
        if (portIdAndNumber.startsWith(PORT_IR)) {
            String number = portIdAndNumber.substring(PORT_IR.length(), tmp.length());
            aCommPort.mCommPortName = PORT_IR;
            aCommPort.mCommPortNumber = CommConnectionUrlParser.getIntValue(number);
        } else if (portIdAndNumber.startsWith(PORT_COM)) {
            String number = portIdAndNumber.substring(PORT_COM.length(), tmp.length());
            aCommPort.mCommPortName = PORT_COM;
            aCommPort.mCommPortNumber = CommConnectionUrlParser.getIntValue(number);
        } else if (portIdAndNumber.startsWith(PORT_USB)) {
            String number = portIdAndNumber.substring(PORT_USB.length(), tmp.length());
            aCommPort.mCommPortName = PORT_USB;
            aCommPort.mCommPortNumber = CommConnectionUrlParser.getIntValue(number);
        } else if (portIdAndNumber.startsWith(PORT_BT)) {
            String number = aPortIdAndNumber.substring(PORT_BT.length(), tmp.length());
            aCommPort.mCommPortName = PORT_BT;
            aCommPort.mCommPortNumber = CommConnectionUrlParser.getIntValue(number);
        } else {
            Logger.LOG(14, 1, "++mapPortNumber() - before throwing connectionotfound exception");
            throw new ConnectionNotFoundException("Not Supported: " + iFullUrl);
        }
    }

    private static int getIntValue(String aValue) throws IllegalArgumentException {
        int ret = 0;
        try {
            ret = Integer.parseInt(aValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid value passed in URI");
        }
        return ret;
    }
}

