/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.comms;

import com.nokia.mj.impl.comms.CommsEndpointBase;
import com.nokia.mj.impl.comms.exception.CommsException;
import com.nokia.mj.impl.rt.support.Jvm;

public final class CommsServerEndpoint
extends CommsEndpointBase {
    private boolean iReleaseHandle;

    public CommsServerEndpoint() {
        this.iHandle = this._create();
        this.iReleaseHandle = true;
    }

    private CommsServerEndpoint(int aHandle) {
        this.iHandle = aHandle;
        this.iReleaseHandle = false;
    }

    public static CommsServerEndpoint find(String aName) {
        int handle = CommsServerEndpoint._find(aName);
        CommsServerEndpoint server = null;
        if (handle != 0) {
            server = new CommsServerEndpoint(handle);
        }
        return server;
    }

    public void start(int aName) throws CommsException {
        this.checkHandle();
        int rc = this._start(this.iHandle, aName);
        if (rc != 0) {
            throw new CommsException("start failed, address=" + aName);
        }
    }

    public void stop() throws CommsException {
        this.checkHandle();
        int rc = this._stop(this.iHandle);
        if (rc != 0) {
            throw new CommsException("stop failed");
        }
    }

    public void destroy() {
        if (this.iHandle != 0) {
            if (this.iReleaseHandle) {
                this._release(this.iHandle);
            } else {
                this._detach(this.iHandle);
            }
        }
        this.iHandle = 0;
    }

    private native int _create();

    private native int _start(int var1, int var2);

    private native int _stop(int var1);

    private static native int _find(String var0);

    static {
        Jvm.loadSystemLibrary("javacomms");
    }
}

