/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.crypto;

import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class CipherImpl {
    private final int iHandle;
    private Finalizer iFinalizer;

    public CipherImpl(String aTransformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Logger.LOG(23, 4, "+ CipherImpl::CipherImpl");
        if (aTransformation == null) {
            throw new NoSuchAlgorithmException("Transformation is null");
        }
        this.iHandle = CipherImpl._create(aTransformation.toUpperCase());
        if (this.iHandle <= 0) {
            if (this.iHandle == -4) {
                throw new OutOfMemoryError();
            }
            if (this.iHandle == -3005) {
                throw new NoSuchPaddingException("Invalid or unsupported padding scheme");
            }
            throw new NoSuchAlgorithmException("No such algorithm");
        }
        this.iFinalizer = this.registerForFinalization();
        Logger.LOG(23, 4, "-- CipherImpl::CipherImpl");
    }

    private Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                CipherImpl.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        CipherImpl._dispose(this.iHandle);
    }

    public int doFinal(byte[] aInput, int aInputOffset, int aInputLen, byte[] aOutput, int aOutputOffset) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        Logger.LOG(23, 4, "+ CipherImpl::doFinal");
        int bytes = 0;
        try {
            bytes = this.privUpdate(aInput, aInputOffset, aInputLen, aOutput, aOutputOffset, true);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new IllegalBlockSizeException("doFinal method failed: " + ibse.getMessage());
        }
        catch (IllegalStateException ise) {
            throw new IllegalStateException("doFinal method failed: " + ise.getMessage());
        }
        catch (ShortBufferException sbe) {
            throw new ShortBufferException("doFinal method failed: " + sbe.getMessage());
        }
        catch (BadPaddingException bpe) {
            throw new BadPaddingException("doFinal method failed: " + bpe.getMessage());
        }
        return bytes;
    }

    public byte[] getIV() {
        Logger.LOG(23, 4, "+ CipherImpl::getIV");
        byte[] nativeIV = CipherImpl._getIV(this.iHandle);
        byte[] retIV = null;
        if (nativeIV != null) {
            retIV = new byte[nativeIV.length];
            System.arraycopy((Object)nativeIV, 0, (Object)retIV, 0, nativeIV.length);
        }
        Logger.LOG(23, 4, "-- CipherImpl::getIV");
        return retIV;
    }

    public void init(int aOpMode, Key aKey) throws InvalidKeyException {
        Logger.LOG(23, 4, "+ CipherImpl::init");
        try {
            this.privInit(aOpMode, aKey, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidKeyException(iape.getMessage());
        }
    }

    public void init(int aOpMode, Key aKey, AlgorithmParameterSpec aParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Logger.LOG(23, 4, "+ CipherImpl::init with params");
        byte[] params = null;
        if (aParams != null) {
            if (!(aParams instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Cipher initializaton failed: algorithm parameter type is not supported");
            }
            params = ((IvParameterSpec)aParams).getIV();
            if (params == null) {
                throw new InvalidAlgorithmParameterException("Cipher initializaton failed: initialization vector is null");
            }
        }
        this.privInit(aOpMode, aKey, params);
        Logger.LOG(23, 4, "-- CipherImpl::init");
    }

    public int update(byte[] aInput, int aInputOffset, int aInputLen, byte[] aOutput, int aOutputOffset) throws IllegalStateException, ShortBufferException {
        Logger.LOG(23, 4, "+ CipherImpl::update");
        int bytes = 0;
        try {
            bytes = this.privUpdate(aInput, aInputOffset, aInputLen, aOutput, aOutputOffset, false);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new ShortBufferException("Update method failed: " + ibse.getMessage());
        }
        catch (BadPaddingException bpe) {
            throw new ShortBufferException("Update method failed: " + bpe.getMessage());
        }
        Logger.LOG(23, 4, "-- CipherImpl::update");
        return bytes;
    }

    private int privUpdate(byte[] aInput, int aInputOffset, int aInputLen, byte[] aOutput, int aOutputOffset, boolean aDoFinal) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int retVal;
        Logger.LOG(23, 4, "+ CipherImpl::privUpdate");
        if (aInputOffset < 0 || aInputLen < 0 || aOutputOffset < 0) {
            throw new IllegalArgumentException("Array offset or length is negative");
        }
        if (aInput.length < aInputOffset + aInputLen) {
            throw new IllegalArgumentException("Array is out of bounds: data do not fit to input buffer");
        }
        if (aInputLen > 0) {
            if (aInput.length <= aInputOffset) {
                throw new IllegalArgumentException("Input offset exceeds array length");
            }
            if (aOutput.length <= aOutputOffset) {
                throw new IllegalArgumentException("Output offset exceeds array length");
            }
        }
        if ((retVal = CipherImpl._update(this.iHandle, aInput, aInputOffset, aInputLen, aOutput, aOutputOffset, aDoFinal)) < 0) {
            if (retVal == -4) {
                throw new OutOfMemoryError();
            }
            if (retVal == -3001) {
                throw new IllegalStateException("init not called successfully");
            }
            if (retVal == -3011) {
                throw new IllegalStateException("invalid input length");
            }
            if (retVal == -3009) {
                throw new ShortBufferException("Updating cipher failed: output buffer too short");
            }
            if (retVal == -3004) {
                throw new IllegalBlockSizeException("illegal block size");
            }
            throw new BadPaddingException("bad padding");
        }
        Logger.LOG(23, 4, "-- CipherImpl::privUpdate");
        return retVal;
    }

    private void privInit(int aOpMode, Key aKey, byte[] aParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Logger.LOG(23, 4, "+ CipherImpl::privInit");
        if (aOpMode != 2 && aOpMode != 1) {
            throw new IllegalArgumentException("Invalid mode: only encrypt and decrypt are supporte");
        }
        if (aKey == null) {
            throw new InvalidKeyException("Key is null");
        }
        int err = CipherImpl._init(this.iHandle, aOpMode, aKey.getAlgorithm().toUpperCase(), aKey.getFormat().toUpperCase(), aKey.getEncoded(), aParams);
        if (err < 0) {
            if (err == -4) {
                throw new OutOfMemoryError();
            }
            if (err == -3008) {
                throw new InvalidAlgorithmParameterException("Invalid parameter");
            }
            throw new InvalidKeyException("Invalid key");
        }
        Logger.LOG(23, 4, "-- CipherImpl::privInit");
    }

    private static native int _create(String var0);

    private static native int _init(int var0, int var1, String var2, String var3, byte[] var4, byte[] var5);

    private static native int _update(int var0, byte[] var1, int var2, int var3, byte[] var4, int var5, boolean var6);

    private static native byte[] _getIV(int var0);

    private static native void _dispose(int var0);

    static {
        try {
            Jvm.loadSystemLibrary("javasatsa");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

