/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.file;

import com.nokia.mj.impl.file.FileConstants;
import com.nokia.mj.impl.file.FileLogger;
import com.nokia.mj.impl.file.FileSystemUtils;
import java.util.Vector;

public class FileAccessHelper
implements FileConstants {
    public static int PATHS_EQUAL = 0;
    public static int PATHS_NO_MATCH = 1;
    public static int PATH_ABOVEIN_HIERARCHY = 2;
    public static int PATH_BELOWIN_HIERARCHY = 3;
    private static String PATH_PRIVATE = "private";
    private static String PATH_SYSTEM = "system";
    private static String[] iRestrictedPathList;
    private static String[] iForbiddenPathList;

    public static boolean accessAllowed(String aPath, String aIntent, String aDomain, boolean aIsOpening) {
        FileLogger.Log("FileAccessHelper.accessAllowed: Checking access: \n");
        if (FileAccessHelper.isHomeDir(aPath)) {
            return true;
        }
        if (FileAccessHelper.isForbidden(aPath)) {
            return false;
        }
        if (FileAccessHelper.isIllegalAccessToRestrictedDir(aPath, aIntent, aIsOpening, aDomain)) {
            return false;
        }
        if (aDomain.equals("MFD")) {
            return FileAccessHelper.manufacturerDomainChecks(aPath, aIntent, aIsOpening);
        }
        return FileAccessHelper.otherDomainChecks(aPath, aIntent, aIsOpening);
    }

    public static boolean isDirRestricted(String aPath) {
        for (int index = 0; index < iRestrictedPathList.length; ++index) {
            int matchResult = FileAccessHelper.matchPaths(aPath, iRestrictedPathList[index]);
            if (matchResult == PATHS_NO_MATCH || matchResult == PATH_BELOWIN_HIERARCHY) continue;
            return true;
        }
        return false;
    }

    private static boolean isForbidden(String aPath) {
        for (int index = 0; index < iForbiddenPathList.length; ++index) {
            int matchPathResult = FileAccessHelper.matchPaths(aPath, iForbiddenPathList[index]);
            if (matchPathResult != PATHS_EQUAL && matchPathResult != PATH_BELOWIN_HIERARCHY) continue;
            return true;
        }
        return false;
    }

    public static boolean isIllegalAccessToRestrictedDir(String aPath, String aIntent, boolean aOpening, String aDomain) {
        for (int index = 0; index < iRestrictedPathList.length; ++index) {
            int matchResult = FileAccessHelper.matchPaths(aPath, iRestrictedPathList[index]);
            if (matchResult == PATHS_NO_MATCH || matchResult == PATH_BELOWIN_HIERARCHY || !aIntent.equals("write") && !aIntent.equals("read,write") || aOpening) continue;
            return true;
        }
        return false;
    }

    public static boolean manufacturerDomainChecks(String aPath, String aIntent, boolean aIsOpening) {
        return aPath.indexOf(PATH_PRIVATE) != 3 || FileAccessHelper.matchPaths(aPath, FileSystemUtils.getAppPrivateDir()) != PATHS_NO_MATCH;
    }

    private static boolean otherDomainChecks(String aPath, String aIntent, boolean aIsOpening) {
        if (aPath.length() < 3) {
            aPath = aPath + "/";
        }
        String rom = FileSystemUtils.getRomDrive().toLowerCase().substring(0, 2);
        String temp = FileSystemUtils.getTemporaryDrive().toLowerCase().substring(0, 2);
        if (aPath.toLowerCase().startsWith(rom) || aPath.toLowerCase().startsWith(temp)) {
            return false;
        }
        for (int index = 0; index < iRestrictedPathList.length; ++index) {
            int matchResult = FileAccessHelper.matchPaths(aPath, iRestrictedPathList[index]);
            if (matchResult == PATH_BELOWIN_HIERARCHY || matchResult == PATHS_NO_MATCH || aIntent.equals("read") || aIsOpening) continue;
            return false;
        }
        return !FileAccessHelper.partialMatchWithRestrictedPaths(aPath);
    }

    private static boolean partialMatchWithRestrictedPaths(String aPath) {
        int index;
        String path1 = aPath;
        boolean initialNoMatch = true;
        for (index = 0; index < iRestrictedPathList.length; ++index) {
            int matchResult = FileAccessHelper.matchPaths(aPath, iRestrictedPathList[index]);
            if (matchResult != PATH_BELOWIN_HIERARCHY && matchResult != PATH_ABOVEIN_HIERARCHY && matchResult != PATHS_EQUAL) continue;
            return false;
        }
        if (path1.length() > 3) {
            path1 = path1.substring(0, path1.lastIndexOf(47));
        }
        while (path1.length() > 3) {
            for (index = 0; index < iRestrictedPathList.length; ++index) {
                if (!iRestrictedPathList[index].toLowerCase().startsWith(path1.toLowerCase())) continue;
                return true;
            }
            path1 = path1.substring(0, path1.lastIndexOf(47));
        }
        return false;
    }

    public static String getCategory(String aPath) {
        FileLogger.Log("+ FileAccessHelper: getCategory: " + aPath);
        if (aPath.equals("SYSTEM_FILES") || aPath.equals("PRIVATE_USER_FILES") || aPath.equals("PUBLIC_DIRS") || aPath.equals("HOME_DIR") || aPath.equals("RESTRICTED_PUBLIC_FILES")) {
            FileLogger.Log("- FileAccessHelper: getCategory: returning: " + aPath);
            return aPath;
        }
        if (aPath.equals("")) {
            return "PUBLIC_DIRS";
        }
        if (FileAccessHelper.isHomeDir(aPath)) {
            return "HOME_DIR";
        }
        int matchResult = PATHS_NO_MATCH;
        for (int index = 0; index < iRestrictedPathList.length; ++index) {
            matchResult = FileAccessHelper.matchPaths(aPath, iRestrictedPathList[index]);
            if (PATH_BELOWIN_HIERARCHY == matchResult) {
                FileLogger.Log("- FileAccessHelper: getCategory: returning: PUBLIC_DIRS");
                return "PUBLIC_DIRS";
            }
            if (PATHS_EQUAL == matchResult) {
                return "PUBLIC_DIRS";
            }
            if (PATH_ABOVEIN_HIERARCHY != matchResult) continue;
            FileLogger.Log("- FileAccessHelper: getCategory: returning: PUBLIC_DIRS");
            return "PUBLIC_DIRS";
        }
        String rom = FileSystemUtils.getRomDrive().toLowerCase().substring(0, 2);
        String temp = FileSystemUtils.getTemporaryDrive().toLowerCase().substring(0, 2);
        if (aPath.toLowerCase().startsWith(rom) || aPath.toLowerCase().startsWith(temp)) {
            FileLogger.Log("- FileAccessHelper: getCategory: returning: SYSTEM_FILES");
            return "SYSTEM_FILES";
        }
        if (aPath.toLowerCase().startsWith(FileSystemUtils.getDefaultRoot().toLowerCase())) {
            FileLogger.Log("- FileAccessHelper: getCategory: returning: RESTRICTED_PUBLIC_FILES");
            return "RESTRICTED_PUBLIC_FILES";
        }
        if (aPath.toLowerCase().indexOf(PATH_PRIVATE) == 3 || aPath.toLowerCase().indexOf(PATH_SYSTEM) == 3) {
            FileLogger.Log("- FileAccessHelper: getCategory: returning: SYSTEM_FILES");
            return "SYSTEM_FILES";
        }
        FileLogger.Log("- FileAccessHelper: getCategory: returning: PUBLIC_DIRS");
        return "PUBLIC_DIRS";
    }

    private static boolean isHomeDir(String aPath) {
        String appPrivateDir = FileSystemUtils.getAppPrivateDir();
        if (aPath.equalsIgnoreCase(appPrivateDir)) {
            return true;
        }
        return aPath.startsWith(appPrivateDir);
    }

    public static boolean isCreateAllowedWithinDir(String aPath, String aDomain) {
        if (aDomain.equals("MFD")) {
            return true;
        }
        boolean allowed = false;
        if (!aPath.startsWith(FileSystemUtils.getDefaultRoot())) {
            return true;
        }
        for (int index = 0; index < iRestrictedPathList.length; ++index) {
            String path = iRestrictedPathList[index];
            int matchResult = FileAccessHelper.matchPaths(aPath, path);
            if (PATHS_EQUAL != matchResult && PATH_BELOWIN_HIERARCHY != matchResult) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    private static int matchPaths(String aPath1, String aPath2) {
        String path2;
        String path1 = aPath1.endsWith("/") ? aPath1.substring(0, aPath1.length() - 1) : aPath1;
        String string = path2 = aPath2.endsWith("/") ? aPath2.substring(0, aPath2.length() - 1) : aPath2;
        if (path1.equalsIgnoreCase(path2)) {
            return PATHS_EQUAL;
        }
        if (path2.toLowerCase().startsWith(path1.toLowerCase())) {
            return PATH_ABOVEIN_HIERARCHY;
        }
        if (path1.toLowerCase().startsWith(path2.toLowerCase())) {
            return PATH_BELOWIN_HIERARCHY;
        }
        return PATHS_NO_MATCH;
    }

    static {
        Vector forbidden = FileSystemUtils.getForbiddenPaths();
        iForbiddenPathList = new String[forbidden.size()];
        for (int index = 0; index < forbidden.size(); ++index) {
            FileAccessHelper.iForbiddenPathList[index] = (String)forbidden.elementAt(index);
        }
        Vector restricted = FileSystemUtils.getRestrictedPaths();
        iRestrictedPathList = new String[restricted.size() + 1];
        for (int index = 0; index < restricted.size(); ++index) {
            FileAccessHelper.iRestrictedPathList[index] = (String)restricted.elementAt(index);
        }
        FileAccessHelper.iRestrictedPathList[restricted.size()] = FileSystemUtils.getAppPrivateDir();
    }
}

